/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.mongodb.it;

import java.util.Map;
import org.apache.camel.quarkus.testcontainers.ContainerResourceLifecycleManager;
import org.apache.camel.util.CollectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.TestcontainersConfiguration;

public class MongoDbTestResource
implements ContainerResourceLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbTestResource.class);
    private static final int MONGODB_PORT = 27017;
    private static final String MONGO_IMAGE = "mongo:4.0";
    private GenericContainer container;

    public Map<String, String> start() {
        LOGGER.info(TestcontainersConfiguration.getInstance().toString());
        try {
            this.container = new GenericContainer(MONGO_IMAGE).withExposedPorts(new Integer[]{27017}).waitingFor((WaitStrategy)Wait.forListeningPort());
            this.container.start();
            return CollectionHelper.mapOf((Object)"camel.mongodb.test-port", (Object)this.container.getMappedPort(27017).toString(), (Object[])new Object[]{"camel.mongodb.test-host", this.container.getContainerIpAddress()});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

