/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.mongodb.gridfs.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.camel.quarkus.test.support.mongodb.MongoDbTestResource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@QuarkusTest
@QuarkusTestResource(value=MongoDbTestResource.class)
class MongodbGridfsTest {
    MongodbGridfsTest() {
    }

    @ParameterizedTest
    @ValueSource(strings={"camelMongoClient", "myMongoClient"})
    public void testMongodbGridfsComponent(String namedClient) {
        String fileContent = "Hello Camel Quarkus MongoDB GridFS [" + namedClient + "]";
        String fileName = namedClient + "-test.txt";
        String objectId = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(fileContent).header("mongoClientName", (Object)namedClient, new Object[0]).post("/mongodb-gridfs/upload/" + fileName, new Object[0])).then()).statusCode(201)).extract().body().asString();
        Assertions.assertNotNull((Object)objectId);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("mongoClientName", (Object)namedClient, new Object[0]).get("/mongodb-gridfs/get/" + fileName, new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)fileContent), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().header("mongoClientName", (Object)namedClient, new Object[0]).delete("/mongodb-gridfs/delete/" + fileName, new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((Response)RestAssured.given().header("mongoClientName", (Object)namedClient, new Object[0]).get("/mongodb-gridfs/get/" + fileName, new Object[0])).then()).statusCode(404);
    }
}

