/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.mock.it;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import org.apache.camel.component.mock.MockComponent;
import org.apache.camel.quarkus.core.events.ComponentAddEvent;
import org.apache.camel.spi.CamelEvent;
import org.jboss.logging.Logger;

@ApplicationScoped
public class CdiConfig {
    private static final Logger LOG = Logger.getLogger(CdiConfig.class);
    private final AtomicBoolean contextStarted = new AtomicBoolean(false);

    public void configureMock(@Observes ComponentAddEvent event) {
        if (event.getComponent() instanceof MockComponent) {
            LOG.info((Object)"Customizing the MockComponent");
            MockComponent mockComponent = (MockComponent)event.getComponent();
            assert (!mockComponent.isLog());
            mockComponent.setLog(true);
            assert (!this.contextStarted.get());
        }
    }

    public void contextStarted(@Observes CamelEvent.CamelContextStartedEvent event) {
        LOG.info((Object)"Camel context started");
        this.contextStarted.set(true);
    }
}

