/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.mock.it;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.reifier.RouteReifier;
import org.jboss.logging.Logger;
import org.wildfly.common.Assert;

@Path(value="/mock")
@ApplicationScoped
public class MockResource {
    private static final Logger LOG = Logger.getLogger(MockResource.class);
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    CamelContext context;

    @Path(value="/advice")
    @GET
    public void advice() throws Exception {
        RouteReifier.adviceWith((RouteDefinition)((RouteDefinition)((ModelCamelContext)this.context.adapt(ModelCamelContext.class)).getRouteDefinitions().get(0)), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.mockEndpoints();
            }
        });
        MockEndpoint mockEndpoint1 = (MockEndpoint)this.context.getEndpoint("mock:direct:start", MockEndpoint.class);
        mockEndpoint1.expectedBodiesReceived(new Object[]{"Hello World"});
        MockEndpoint mockEndpoint2 = (MockEndpoint)this.context.getEndpoint("mock:direct:foo", MockEndpoint.class);
        mockEndpoint2.expectedBodiesReceived(new Object[]{"Hello World"});
        MockEndpoint mockEndpoint3 = (MockEndpoint)this.context.getEndpoint("mock:log:foo", MockEndpoint.class);
        mockEndpoint3.expectedBodiesReceived(new Object[]{"Bye World"});
        MockEndpoint mockEndpoint4 = (MockEndpoint)this.context.getEndpoint("mock:result", MockEndpoint.class);
        mockEndpoint4.expectedBodiesReceived(new Object[]{"Bye World"});
        this.producerTemplate.sendBody("direct:start", (Object)"Hello World");
        mockEndpoint1.assertIsSatisfied();
        mockEndpoint2.assertIsSatisfied();
        mockEndpoint3.assertIsSatisfied();
        mockEndpoint4.assertIsSatisfied();
        Assert.assertNotNull((Object)this.context.hasEndpoint("direct:start"));
        Assert.assertNotNull((Object)this.context.hasEndpoint("direct:foo"));
        Assert.assertNotNull((Object)this.context.hasEndpoint("log:foo"));
        Assert.assertNotNull((Object)this.context.hasEndpoint("mock:result"));
        Assert.assertNotNull((Object)this.context.hasEndpoint("mock:direct:start"));
        Assert.assertNotNull((Object)this.context.hasEndpoint("mock:direct:foo"));
        Assert.assertNotNull((Object)this.context.hasEndpoint("mock:log:foo"));
    }

    @Path(value="/basic")
    @POST
    @Consumes(value={"text/plain"})
    public void post(String message) throws Exception {
        MockEndpoint mockEndpoint = (MockEndpoint)this.context.getEndpoint("mock:foo", MockEndpoint.class);
        mockEndpoint.expectedBodyReceived().constant((Object)message);
        mockEndpoint.setExpectedCount(1);
        LOG.infof("Sending to mock: %s", (Object)message);
        String response = (String)this.producerTemplate.requestBody("mock:foo", (Object)message, String.class);
        LOG.infof("Got response from mock: %s", (Object)response);
        mockEndpoint.assertIsSatisfied();
    }
}

