/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.minio.it;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.time.Duration;
import java.util.Map;
import org.apache.camel.quarkus.component.minio.it.MinioProducer;
import org.apache.camel.quarkus.component.minio.it.MinioTest;
import org.apache.camel.util.CollectionHelper;
import org.eclipse.microprofile.config.ConfigProvider;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;

public class MinioTestResource
implements QuarkusTestResourceLifecycleManager {
    public static final String CONTAINER_ACCESS_KEY = "MINIO_ACCESS_KEY";
    public static final String CONTAINER_SECRET_KEY = "MINIO_SECRET_KEY";
    private static final String CONTAINER_IMAGE = (String)ConfigProvider.getConfig().getValue("minio.container.image", String.class);
    private static final int BROKER_PORT = 9000;
    private String endpoint;
    private GenericContainer minioServer = new GenericContainer(CONTAINER_IMAGE).withEnv("MINIO_ACCESS_KEY", "testAccessKey").withEnv("MINIO_SECRET_KEY", "testSecretKey").withCommand("server /data").withExposedPorts(new Integer[]{9000}).waitingFor(new HttpWaitStrategy().forPath("/minio/health/ready").forPort(9000).withStartupTimeout(Duration.ofSeconds(10L)));

    public Map<String, String> start() {
        this.minioServer.start();
        String port = "" + this.minioServer.getMappedPort(9000);
        String host = this.minioServer.getHost();
        this.endpoint = String.format("http://%s:%s", host, port);
        return CollectionHelper.mapOf((Object)MinioProducer.MINIO_CLIENT_URL_PARAMETER, (Object)this.endpoint, (Object[])new Object[0]);
    }

    public void stop() {
        if (this.minioServer.isRunning()) {
            this.minioServer.stop();
        }
    }

    public void inject(Object testInstance) {
        ((MinioTest)testInstance).setEndpoint(this.endpoint);
    }
}

