/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.minio.it;

import io.minio.MinioClient;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import org.apache.camel.component.minio.MinioComponent;
import org.eclipse.microprofile.config.ConfigProvider;

public class MinioProducer {
    public static String MINIO_CLIENT_URL_PARAMETER = MinioProducer.class.getSimpleName() + "_url";

    @Produces
    @Singleton
    @Named(value="minioClient")
    public MinioClient produceMinioClient() {
        return MinioClient.builder().endpoint((String)ConfigProvider.getConfig().getValue(MINIO_CLIENT_URL_PARAMETER, String.class)).credentials("testAccessKey", "testSecretKey").build();
    }

    @Produces
    @Named(value="minioComponentWithoutClient")
    MinioComponent camelMinioComponent() {
        MinioComponent minioComponent = new MinioComponent();
        minioComponent.setAutowiredEnabled(false);
        return minioComponent;
    }
}

