/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.minio.it;

import io.minio.BucketExistsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.errors.MinioException;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.camel.component.minio.MinioOperations;
import org.apache.camel.quarkus.component.minio.it.MinioProducer;
import org.apache.camel.quarkus.component.minio.it.MinioTestResource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=MinioTestResource.class)
class MinioTest {
    private static final long PART_SIZE = 0x3200000L;
    private final String BUCKET_NAME = "mycamel";
    private MinioClient minioClient;
    String endpoint;

    MinioTest() {
    }

    @Test
    public void testConsumerMoveAfterRead() throws Exception {
        this.initClient("mycamel");
        this.sendViaClient("Hi Sheldon!", "consumerObjectMAR");
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/minio/consumer", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"Hi Sheldon!"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("params", new Object[]{MinioTest.params("CamelMinioOperation", MinioOperations.getObject, "CamelMinioObjectName", "consumerObjectMAR", "CamelMinioBucketName", "movedafterread")}).post("minio/operation", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hi Sheldon!"), new Matcher[0]);
    }

    @Test
    public void testConsumerWithoutDetectionOfClient() throws Exception {
        this.initClient("mycamel");
        this.sendViaClient("Hi Sheldon!", "consumerObject");
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/minio/consumerWithClientCreation/" + this.endpoint), (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"Hi Sheldon!"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("params", new Object[]{MinioTest.params("CamelMinioOperation", MinioOperations.getObject, "CamelMinioObjectName", "consumerObject", "CamelMinioBucketName", "movedafterread")}).post("minio/operation", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hi Sheldon!"), new Matcher[0]);
        this.sendViaClient("Hi Sheldon!", "consumerObject");
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/minio/consumerWithClientCreation/non_existing_endpoint_!@#$", (Object[])new Object[0]).then()).statusCode(500)).body(Matchers.startsWith((String)"invalid hostname"), new Matcher[0]);
    }

    @Test
    public void testDeleteObject() throws Exception {
        this.initClient("mycamel");
        this.sendViaClient("Dummy content", "testDeleteObject");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("params", new Object[]{MinioTest.params("CamelMinioOperation", MinioOperations.listObjects)}).post("/minio/operation", new Object[0])).then()).statusCode(200)).body(Matchers.containsString((String)"item: testDeleteObject"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("params", new Object[]{MinioTest.params("CamelMinioOperation", MinioOperations.deleteObject, "CamelMinioObjectName", "testDeleteObject")}).post("/minio/operation", new Object[0])).then()).statusCode(200)).body(Matchers.containsString((String)"true"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("params", new Object[]{MinioTest.params("CamelMinioOperation", MinioOperations.listObjects)}).post("/minio/operation", new Object[0])).then()).statusCode(200)).body(Matchers.not((Matcher)Matchers.containsString((String)"item: testDeleteObject")), new Matcher[0]);
    }

    @Test
    public void testDeleteBucket() throws Exception {
        this.initClient("mycamel");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("params", new Object[]{MinioTest.params("CamelMinioOperation", MinioOperations.listBuckets)}).post("/minio/operation", new Object[0])).then()).statusCode(200)).body(Matchers.containsString((String)"bucket: mycamel"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("params", new Object[]{MinioTest.params("CamelMinioOperation", MinioOperations.deleteBucket, "CamelMinioBucketName", "mycamel")}).post("/minio/operation", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("params", new Object[]{MinioTest.params("CamelMinioOperation", MinioOperations.listBuckets)}).post("/minio/operation", new Object[0])).then()).statusCode(200)).body(Matchers.not((Matcher)Matchers.containsString((String)"bucket: mycamel")), new Matcher[0]);
    }

    @Test
    public void testBasicOperations() throws Exception {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("params", new Object[]{MinioTest.params("CamelMinioObjectName", "putName")}).body("Hi Sheldon.").post("minio/operation", new Object[0])).then()).statusCode(200)).body(Matchers.containsString((String)"Hi Sheldon"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("params", new Object[]{MinioTest.params("CamelMinioOperation", MinioOperations.copyObject, "CamelMinioObjectName", "putName", "CamelMinioDestinationObjectName", "copyName", "CamelMinioDestinationBucketName", "mycamel")}).post("minio/operation", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("params", new Object[]{MinioTest.params("CamelMinioOperation", MinioOperations.getObject, "CamelMinioObjectName", "copyName")}).post("minio/operation", new Object[0])).then()).statusCode(200)).body(Matchers.containsString((String)"Hi Sheldon"), new Matcher[0]);
    }

    @Test
    public void testGetViaPojo() throws Exception {
        this.initClient("mycamel");
        this.initClient("mycamel2");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("params", new Object[]{MinioTest.params("CamelMinioObjectName", "putViaPojoName")}).body("Hi Sheldon.").post("minio/operation", new Object[0])).then()).statusCode(200)).body(Matchers.containsString((String)"Hi Sheldon"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("params", new Object[]{MinioTest.params("CamelMinioOperation", MinioOperations.copyObject, "CamelMinioObjectName", "putViaPojoName", "CamelMinioDestinationObjectName", "copyViaPojoName", "CamelMinioDestinationBucketName", "mycamel2")}).body("Hi Sheldon.").post("minio/operation", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("CamelMinioOperation", new Object[]{MinioOperations.getObject}).queryParam("CamelMinioObjectName", new Object[]{"copyViaPojoName"}).body("mycamel2").post("/minio/getUsingPojo", new Object[0])).then()).statusCode(200)).body(Matchers.containsString((String)"Hi Sheldon"), new Matcher[0]);
    }

    @Test
    public void testMoveDataBetweenBuckets() throws Exception {
        MinioClient mc = this.initClient("movingfrombucket");
        this.initClient("movingtobucket");
        this.sendViaClient(mc, "movingfrombucket", "Hi Sheldon!", "object1");
        ((ValidatableResponse)RestAssured.get((String)"/minio/consumeAndMove/true", (Object[])new Object[0]).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("params", new Object[]{MinioTest.params("CamelMinioOperation", MinioOperations.getObject, "CamelMinioObjectName", "object1", "CamelMinioBucketName", "movingtobucket")}).post("minio/operation", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hi Sheldon!"), new Matcher[0]);
        this.sendViaClient(mc, "movingfrombucket", "Hi Leonard!", "object2");
        ((ValidatableResponse)RestAssured.get((String)"/minio/consumeAndMove/false", (Object[])new Object[0]).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("params", new Object[]{MinioTest.params("CamelMinioOperation", MinioOperations.getObject, "CamelMinioObjectName", "object2", "CamelMinioBucketName", "movingtobucket")}).post("minio/operation", new Object[0])).then()).statusCode(500)).body(Matchers.is((Object)"The specified key does not exist."), new Matcher[0]);
    }

    @Test
    void testGetObjectRange() throws Exception {
        MinioClient client = this.initClient("mycamel");
        this.sendViaClient(client, "MinIO is a cloud storage server compatible with Amazon S3, ...", "element.txt");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("params", new Object[]{MinioTest.params("CamelMinioOperation", MinioOperations.getPartialObject, "CamelMinioOffset", 1, "CamelMinioLength", 8, "CamelMinioObjectName", "element.txt")}).post("minio/operation", new Object[0])).then()).statusCode(200)).body(Matchers.containsString((String)"inIO is"), new Matcher[0]);
    }

    @Test
    public void testAutocreateBucket() throws Exception {
        this.initClient("mycamel");
        String nonExistingBucket1 = "nonexistingbucket1";
        String nonExistingBucket2 = "nonexistingbucket2";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("params", new Object[]{MinioTest.params("CamelMinioOperation", MinioOperations.listBuckets, "autoCreateBucket", "true", "bucket", nonExistingBucket1)}).post("/minio/operation", new Object[0])).then()).statusCode(200)).body((Matcher)Matchers.both((Matcher)Matchers.containsString((String)"bucket: mycamel")).and(Matchers.containsString((String)("bucket: " + nonExistingBucket1))), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("params", new Object[]{MinioTest.params("CamelMinioOperation", MinioOperations.listBuckets, "autoCreateBucket", "false", "bucket", nonExistingBucket2)}).post("/minio/operation", new Object[0])).then()).statusCode(200)).body(Matchers.not((Matcher)Matchers.containsString((String)nonExistingBucket2)), new Matcher[0]);
    }

    @Test
    public void testETag() throws Exception {
        this.initClient("mycamel");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("params", new Object[]{MinioTest.params("CamelMinioObjectName", "element1.txt")}).queryParam("returnHeaders", new Object[]{true}).body("MinIO is a cloud storage server compatible with Amazon S3, ...").post("minio/operation", new Object[0])).then()).statusCode(200)).body(Matchers.matchesPattern((String)"headers.*CamelMinioETag:\\w+.+"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("params", new Object[]{MinioTest.params("CamelMinioOperation", MinioOperations.getObject, "CamelMinioObjectName", "element1.txt")}).post("minio/operation", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"MinIO is a cloud storage server compatible with Amazon S3, ..."), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("params", new Object[]{MinioTest.params("CamelMinioOperation", MinioOperations.deleteObject, "CamelMinioObjectName", "element1.txt")}).post("/minio/operation", new Object[0])).then()).statusCode(200)).body(Matchers.containsString((String)"true"), new Matcher[0]);
    }

    private static String params(Object ... os) {
        return Stream.concat(Arrays.stream(new String[]{os[0].toString()}), IntStream.range(1, os.length).mapToObj(i -> (i % 2 == 0 ? "," : ":") + os[i].toString())).collect(Collectors.joining());
    }

    private MinioClient initClient(String bucketName) throws Exception {
        if (this.minioClient == null) {
            this.minioClient = new MinioProducer().produceMinioClient();
        }
        if (!this.minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build())) {
            this.minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
        }
        return this.minioClient;
    }

    private void sendViaClient(String content, String objectName) {
        this.sendViaClient(this.minioClient, content, objectName);
    }

    private void sendViaClient(MinioClient client, String content, String objectName) {
        this.sendViaClient(client, "mycamel", content, objectName);
    }

    private void sendViaClient(MinioClient client, String bucketName, String content, String objectName) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes());){
            client.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(objectName)).contentType("text/xml").stream((InputStream)is, -1L, 0x3200000L).build());
        }
        catch (MinioException | IOException | GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }
}

