/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.minio.it;

import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.Result;
import io.minio.messages.Bucket;
import io.minio.messages.Item;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.minio.MinioOperations;
import org.apache.camel.util.Pair;

@Path(value="/minio")
@ApplicationScoped
public class MinioResource {
    public static final String SERVER_ACCESS_KEY = "testAccessKey";
    public static final String SERVER_SECRET_KEY = "testSecretKey";
    private static final String URL_AUTH = "accessKey=testAccessKey&secretKey=RAW(testSecretKey)";
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;
    @Inject
    CamelContext camelContext;

    @Path(value="/consumerWithClientCreation/{endpoint}")
    @GET
    @Produces(value={"text/plain"})
    public Response consumerWithClientCreation(@PathParam(value="endpoint") String endpoint) {
        try {
            String url = "minioComponentWithoutClient://mycamel?endpoint=" + endpoint + "&moveAfterRead=true&destinationBucketName=movedafterread&accessKey=testAccessKey&secretKey=RAW(testSecretKey)";
            return Response.ok().entity(this.consumerTemplate.receiveBody(url, 5000L, String.class)).build();
        }
        catch (Exception e) {
            return Response.status((int)500).entity((Object)e.getCause().getMessage()).build();
        }
    }

    @Path(value="/consumer")
    @GET
    @Produces(value={"text/plain"})
    public String consumer() {
        String message = (String)this.consumerTemplate.receiveBody("minio://mycamel?moveAfterRead=true&destinationBucketName=movedafterread", 5000L, String.class);
        return message;
    }

    @Path(value="/consumeAndMove/{removeHeader}")
    @GET
    @Produces(value={"text/plain"})
    public Response consumeAndMove(@PathParam(value="removeHeader") boolean removeHeader) {
        Exchange exchange = this.consumerTemplate.receive("minio://movingfrombucket?deleteAfterRead=true", 5000L);
        Exchange exchangeToSend = exchange.copy();
        if (removeHeader) {
            exchangeToSend.getIn().removeHeader("CamelMinioBucketName");
        }
        this.producerTemplate.send("minio://movingtobucket", exchangeToSend);
        return Response.ok().build();
    }

    @Path(value="/getUsingPojo")
    @POST
    @Produces(value={"text/plain"})
    @Consumes(value={"text/plain"})
    public String getUsingPojo(String bucket, @QueryParam(value="CamelMinioObjectName") String objectName) {
        String endpoint = "minio:mycamel?pojoRequest=true&minioClient=#minioClient";
        GetObjectArgs.Builder body = (GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucket)).object(objectName);
        Map<String, MinioOperations> headers = Collections.singletonMap("CamelMinioOperation", MinioOperations.getObject);
        return (String)this.producerTemplate.requestBodyAndHeaders(endpoint, (Object)body, headers, String.class);
    }

    @Path(value="/operation")
    @POST
    @Produces(value={"text/plain"})
    @Consumes(value={"text/plain"})
    public Response operation(String body, @QueryParam(value="params") String parametersString, @QueryParam(value="returnHeaders") boolean returnHeaders) {
        Iterable objectList;
        Map<String, Object> headers = this.deserializeMap(parametersString);
        Object endpoint = String.format("minio:%s?accessKey=testAccessKey&secretKey=RAW(testSecretKey)", headers.getOrDefault("bucket", "mycamel"));
        headers.remove("bucket");
        if (headers.containsKey("autoCreateBucket")) {
            endpoint = (String)endpoint + "&autoCreateBucket=" + headers.remove("autoCreateBucket");
        }
        MinioOperations op = headers.getOrDefault("CamelMinioOperation", null);
        Integer length = headers.getOrDefault("CamelMinioLength", null);
        Integer offset = headers.getOrDefault("CamelMinioOffset", null);
        if (op == MinioOperations.getObject) {
            try {
                return Response.ok().entity(this.producerTemplate.requestBodyAndHeaders((String)endpoint, (Object)body, headers, String.class)).build();
            }
            catch (Exception e2) {
                return Response.status((int)500).entity((Object)e2.getCause().getMessage()).build();
            }
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder errorSB = new StringBuilder();
        try {
            Exchange exchange = this.producerTemplate.request((String)endpoint, e -> {
                e.getIn().setHeaders(headers);
                e.getIn().setBody((Object)body);
            });
            if (returnHeaders) {
                sb.append("headers[").append(exchange.getIn().getHeaders().entrySet().stream().map(e -> (String)e.getKey() + ":" + e.getValue()).collect(Collectors.joining(","))).append("]");
            }
            objectList = (Iterable)exchange.getIn(Iterable.class);
        }
        catch (Exception e3) {
            return Response.status((int)500).entity((Object)e3.getMessage()).build();
        }
        this.formatResult(length, offset, objectList, sb, errorSB);
        Response.ResponseBuilder respBuilder = errorSB.length() > 0 ? Response.status((int)500).entity((Object)errorSB.toString()) : Response.ok().entity((Object)sb.toString());
        return respBuilder.build();
    }

    private void formatResult(Integer length, Integer offset, Iterable<?> objectList, StringBuilder sb, StringBuilder errorSB) {
        objectList.forEach(r -> {
            try {
                if (r instanceof Result) {
                    Object o = ((Result)r).get();
                    if (o instanceof Item) {
                        sb.append("item: ").append(((Item)o).objectName());
                    } else {
                        sb.append(o);
                    }
                } else if (r instanceof Bucket) {
                    sb.append("bucket: ").append(((Bucket)r).name());
                } else if (r instanceof GetObjectResponse) {
                    if (length != null && offset != null) {
                        byte[] bytes = new byte[length.intValue()];
                        ((GetObjectResponse)r).read(bytes, 0, length - offset);
                        sb.append(new String(bytes, StandardCharsets.UTF_8));
                    } else {
                        errorSB.append("Offset and length is required!");
                    }
                } else {
                    sb.append(r);
                }
                sb.append(", ");
            }
            catch (Exception e) {
                errorSB.append(e);
            }
        });
    }

    private Map<String, Object> deserializeMap(String parametersString) {
        return Arrays.stream(parametersString.split(",")).map(s -> new Pair((Object)s.split(":")[0], (Object)s.split(":")[1])).map(p -> {
            switch ((String)p.getLeft()) {
                case "CamelMinioOffset": 
                case "CamelMinioLength": {
                    return new Pair((Object)((Serializable)p.getLeft()), (Object)Integer.parseInt((String)p.getRight()));
                }
                case "CamelMinioOperation": {
                    return new Pair((Object)((Serializable)p.getLeft()), (Object)MinioOperations.valueOf((String)((String)p.getRight())));
                }
            }
            return p;
        }).collect(Collectors.toMap(p -> ((Serializable)p.getLeft()).toString(), Pair::getRight));
    }
}

