/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.minio.it;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.time.Duration;
import java.util.Map;
import org.apache.camel.quarkus.component.minio.it.MinioClientProducer;
import org.apache.camel.util.CollectionHelper;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;

public class MinioTestResource
implements QuarkusTestResourceLifecycleManager {
    public static final String CONTAINER_ACCESS_KEY = "MINIO_ACCESS_KEY";
    public static final String CONTAINER_SECRET_KEY = "MINIO_SECRET_KEY";
    private final String CONTAINER_IMAGE = "minio/minio:RELEASE.2020-12-03T05-49-24Z";
    private final int BROKER_PORT = 9000;
    private GenericContainer minioServer = new GenericContainer("minio/minio:RELEASE.2020-12-03T05-49-24Z").withEnv("MINIO_ACCESS_KEY", "testAccessKey").withEnv("MINIO_SECRET_KEY", "testSecretKey").withCommand("server /data").withExposedPorts(new Integer[]{9000}).waitingFor(new HttpWaitStrategy().forPath("/minio/health/ready").forPort(9000).withStartupTimeout(Duration.ofSeconds(10L)));

    public Map<String, String> start() {
        this.minioServer.start();
        String port = "" + this.minioServer.getMappedPort(9000);
        String host = this.minioServer.getHost();
        return CollectionHelper.mapOf((Object)MinioClientProducer.MINIO_CLIENT_URL_PARAMETER, (Object)String.format("http://%s:%s", host, port), (Object[])new Object[0]);
    }

    public void stop() {
        if (this.minioServer.isRunning()) {
            this.minioServer.stop();
        }
    }
}

