/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.minio.it;

import io.minio.GetObjectArgs;
import io.minio.Result;
import io.minio.messages.Bucket;
import io.minio.messages.Item;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.minio.MinioOperations;

@Path(value="/minio")
@ApplicationScoped
public class MinioResource {
    public static final String SERVER_ACCESS_KEY = "testAccessKey";
    public static final String SERVER_SECRET_KEY = "testSecretKey";
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;

    @Path(value="/consumer")
    @GET
    @Produces(value={"text/plain"})
    public String consumer() {
        String message = (String)this.consumerTemplate.receiveBody("minio://mycamel?moveAfterRead=true&destinationBucketName=camel-kafka-connector&autoCreateBucket=true&accessKey=testAccessKey&secretKey=RAW(testSecretKey)", 5000L, String.class);
        return message;
    }

    @Path(value="/operation")
    @POST
    @Produces(value={"text/plain"})
    @Consumes(value={"text/plain"})
    public String operation(String body, @QueryParam(value="CamelMinioOperation") String operation, @QueryParam(value="CamelMinioObjectName") String objectName, @QueryParam(value="CamelMinioDestinationObjectName") String destinationObjectName, @QueryParam(value="CamelMinioDestinationBucketName") String destinationBucketName) {
        String endpoint = "minio:mycamel?accessKey=testAccessKey&secretKey=RAW(testSecretKey)";
        MinioOperations op = operation != "" && !"".equals(operation) ? MinioOperations.valueOf((String)operation) : null;
        HashMap<String, Object> headers = new HashMap<String, Object>();
        if (op != null) {
            headers.put("CamelMinioOperation", op);
        }
        if (objectName != null) {
            headers.put("CamelMinioObjectName", objectName);
        }
        if (destinationObjectName != null) {
            headers.put("CamelMinioDestinationObjectName", destinationObjectName);
        }
        if (destinationBucketName != null) {
            headers.put("CamelMinioDestinationBucketName", destinationBucketName);
        }
        if (op == MinioOperations.getObject) {
            return (String)this.producerTemplate.requestBodyAndHeaders(endpoint, (Object)body, headers, String.class);
        }
        Iterable objectList = (Iterable)this.producerTemplate.requestBodyAndHeaders(endpoint, (Object)body, headers, Iterable.class);
        StringBuilder sb = new StringBuilder();
        StringBuilder errorSB = new StringBuilder();
        objectList.forEach(r -> {
            try {
                if (r instanceof Result) {
                    Object o = ((Result)r).get();
                    if (o instanceof Item) {
                        sb.append("item: ").append(((Item)o).objectName());
                    } else {
                        sb.append(o);
                    }
                }
                if (r instanceof Bucket) {
                    sb.append("bucket: ").append(((Bucket)r).name());
                } else {
                    sb.append(r);
                }
                sb.append(", ");
            }
            catch (Exception e) {
                errorSB.append(e.toString());
            }
        });
        return errorSB.length() > 0 ? errorSB.toString() : sb.toString();
    }

    @Path(value="/getUsingPojo")
    @POST
    @Produces(value={"text/plain"})
    @Consumes(value={"text/plain"})
    public String getUsingPojo(String bucket, @QueryParam(value="CamelMinioObjectName") String objectName) {
        String endpoint = "minio:mycamel?accessKey=testAccessKey&secretKey=RAW(testSecretKey)&pojoRequest=true&minioClient=#minioClient";
        GetObjectArgs.Builder body = (GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucket)).object(objectName);
        Map<String, MinioOperations> headers = Collections.singletonMap("CamelMinioOperation", MinioOperations.getObject);
        return (String)this.producerTemplate.requestBodyAndHeaders(endpoint, (Object)body, headers, String.class);
    }
}

