/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.minio.it;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.quarkus.component.minio.it.MinioResource;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

public class MinioConfigProvider
implements ConfigSourceProvider {
    private final MinioConfig minioConfig = new MinioConfig();

    public Iterable<ConfigSource> getConfigSources(ClassLoader forClassLoader) {
        return Collections.singletonList(this.minioConfig);
    }

    private static final class MinioConfig
    implements ConfigSource {
        private final Map<String, String> values = new HashMap<String, String>(){
            {
                this.put("quarkus.minio.url", String.format("http://%s:%s", System.getProperty(MinioResource.PARAM_SERVER_HOST), System.getProperty(MinioResource.PARAM_SERVER_PORT)));
                this.put("quarkus.minio.access-key", "testAccessKey");
                this.put("quarkus.minio.secret-key", "testSecretKey");
            }
        };

        private MinioConfig() {
        }

        public Map<String, String> getProperties() {
            return this.values;
        }

        public String getValue(String propertyName) {
            return this.values.get(propertyName);
        }

        public String getName() {
            return MinioConfig.class.getName();
        }
    }
}

