/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.minio.it;

import java.time.Duration;
import java.util.Map;
import org.apache.camel.quarkus.component.minio.it.MinioResource;
import org.apache.camel.quarkus.testcontainers.ContainerResourceLifecycleManager;
import org.apache.camel.util.CollectionHelper;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;

public class MinioTestResource
implements ContainerResourceLifecycleManager {
    public static final String CONTAINER_ACCESS_KEY = "MINIO_ACCESS_KEY";
    public static final String CONTAINER_SECRET_KEY = "MINIO_SECRET_KEY";
    private final String CONTAINER_IMAGE = "minio/minio:RELEASE.2020-12-03T05-49-24Z";
    private final int BROKER_PORT = 9000;
    private GenericContainer minioServer = new GenericContainer("minio/minio:RELEASE.2020-12-03T05-49-24Z").withEnv("MINIO_ACCESS_KEY", "testAccessKey").withEnv("MINIO_SECRET_KEY", "testSecretKey").withCommand("server /data").withExposedPorts(new Integer[]{9000}).waitingFor(new HttpWaitStrategy().forPath("/minio/health/ready").forPort(9000).withStartupTimeout(Duration.ofSeconds(10L)));

    public Map<String, String> start() {
        this.minioServer.start();
        return CollectionHelper.mapOf((Object)MinioResource.PARAM_SERVER_PORT, (Object)(this.minioServer.getMappedPort(9000) + ""), (Object[])new Object[]{MinioResource.PARAM_SERVER_HOST, this.minioServer.getHost()});
    }

    public void stop() {
        if (this.minioServer.isRunning()) {
            this.minioServer.stop();
        }
    }
}

