/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.minio.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.camel.component.minio.MinioOperations;
import org.apache.camel.quarkus.component.minio.it.MinioTestResource;
import org.apache.camel.util.CollectionHelper;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=MinioTestResource.class)
class MinioTest {
    private final String BUCKET_NAME = "mycamel";

    MinioTest() {
    }

    @Test
    public void testConsumer() throws Exception {
        this.initClient();
        this.sendViaClient("Dummy content", "consumerObject");
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).untilAsserted(() -> {
            String result = ((ValidatableResponse)RestAssured.get((String)"/minio/consumer", (Object[])new Object[0]).then()).extract().asString();
            Assertions.assertEquals((Object)"Dummy content", (Object)result);
        });
    }

    @Test
    public void testDeleteObject() throws Exception {
        this.initClient();
        this.sendViaClient("Dummy content", "testDeleteObject");
        ((ValidatableResponse)this.producerRequest(MinioOperations.listObjects, null, Collections.emptyMap()).statusCode(200)).body(Matchers.containsString((String)"item: testDeleteObject"), new Matcher[0]);
        ((ValidatableResponse)this.producerRequest(MinioOperations.deleteObject, null, Collections.singletonMap("CamelMinioObjectName", "testDeleteObject")).statusCode(200)).body(Matchers.containsString((String)"true"), new Matcher[0]);
        ((ValidatableResponse)this.producerRequest(MinioOperations.listObjects, null, Collections.emptyMap()).statusCode(200)).body(Matchers.equalTo((Object)""), new Matcher[0]);
    }

    @Test
    public void testDeleteBucket() throws Exception {
        this.initClient();
        ((ValidatableResponse)this.producerRequest(MinioOperations.listBuckets, null, Collections.emptyMap()).statusCode(200)).body(Matchers.containsString((String)"bucket: mycamel"), new Matcher[0]);
        this.producerRequest(MinioOperations.deleteBucket, null, Collections.emptyMap()).statusCode(200);
        ((ValidatableResponse)this.producerRequest(MinioOperations.listBuckets, null, Collections.emptyMap()).statusCode(200)).body(Matchers.equalTo((Object)""), new Matcher[0]);
    }

    @Test
    public void testBasicOperations() throws Exception {
        this.initClient();
        ((ValidatableResponse)this.producerRequest(null, "Hi Sheldon.", Collections.singletonMap("CamelMinioObjectName", "putName")).statusCode(200)).body(Matchers.containsString((String)"Hi Sheldon"), new Matcher[0]);
        this.producerRequest(MinioOperations.copyObject, null, CollectionHelper.mapOf((Object)"CamelMinioObjectName", (Object)"putName", (Object[])new Object[]{"CamelMinioDestinationObjectName", "copyName", "CamelMinioDestinationBucketName", "mycamel"})).statusCode(200);
        ((ValidatableResponse)this.producerRequest(MinioOperations.getObject, null, Collections.singletonMap("CamelMinioObjectName", "copyName")).statusCode(200)).body(Matchers.containsString((String)"Hi Sheldon"), new Matcher[0]);
    }

    @Test
    public void testGetViaPojo() throws Exception {
        this.initClient();
        this.initClient("mycamel2");
        ((ValidatableResponse)this.producerRequest(null, "Hi Sheldon.", Collections.singletonMap("CamelMinioObjectName", "putViaPojoName")).statusCode(200)).body(Matchers.containsString((String)"Hi Sheldon"), new Matcher[0]);
        this.producerRequest(MinioOperations.copyObject, null, CollectionHelper.mapOf((Object)"CamelMinioObjectName", (Object)"putViaPojoName", (Object[])new Object[]{"CamelMinioDestinationObjectName", "copyViaPojoName", "CamelMinioDestinationBucketName", "mycamel2"})).statusCode(200);
        ((ValidatableResponse)this.producerRequest(MinioOperations.getObject, "mycamel2", Collections.singletonMap("CamelMinioObjectName", "copyViaPojoName"), "/minio/getUsingPojo").statusCode(200)).body(Matchers.containsString((String)"Hi Sheldon"), new Matcher[0]);
    }

    private ValidatableResponse producerRequest(MinioOperations operation, String body, Map<String, String> params) {
        return this.producerRequest(operation, body, params, "/minio/operation");
    }

    private ValidatableResponse producerRequest(MinioOperations operation, String body, Map<String, String> params, String path) {
        RequestSpecification request = RestAssured.given().contentType(ContentType.TEXT).queryParam("CamelMinioOperation", new Object[]{operation != null ? operation.name() : null});
        params.forEach((k, v) -> request.queryParam(k, new Object[]{v}));
        return (ValidatableResponse)((Response)request.body(body == null ? "" : body).post(path, new Object[0])).then();
    }

    private void initClient() throws Exception {
        this.initClient("mycamel");
    }

    private void initClient(String bucketName) throws Exception {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(bucketName).post("/minio/initBucket", new Object[0])).then()).statusCode(204);
    }

    private void sendViaClient(String content, String objectName) {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("CamelMinioObjectName", new Object[]{objectName}).queryParam("CamelMinioBucketName", new Object[]{"mycamel"}).body(content).post("/minio/putObject", new Object[0])).then()).statusCode(204);
    }
}

