/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.microprofile.it.health;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.camel.ServiceStatus;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
class MicroProfileHealthTest {
    MicroProfileHealthTest() {
    }

    @Test
    public void testHealthUpStatus() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/q/health", new Object[0])).then()).contentType(ContentType.JSON)).header("Content-Type", Matchers.containsString((String)"charset=UTF-8"))).body("status", Matchers.is((Object)"UP"), new Object[]{"checks.status.findAll().unique()", Matchers.contains((Object[])new String[]{"UP"}), "checks.find { it.name == 'camel-routes' }", Matchers.notNullValue(), "checks.find { it.name == 'camel-consumers' }", Matchers.notNullValue(), "checks.find { it.name == 'context' }", Matchers.notNullValue(), "checks.find { it.name == 'context' }.data.'context.name'", Matchers.notNullValue()});
    }

    @Test
    public void testHealthDownStatus() {
        try {
            ((ValidatableResponse)((Response)RestAssured.given().queryParam("healthCheckEnabled", new Object[]{"true"}).post("/microprofile-health/failing-check", new Object[0])).then()).statusCode(204);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/q/health", new Object[0])).then()).contentType(ContentType.JSON)).header("Content-Type", Matchers.containsString((String)"charset=UTF-8"))).body("status", Matchers.is((Object)"DOWN"), new Object[]{"checks.findAll { it.name == 'failing-check' }.status", Matchers.contains((Object[])new String[]{"DOWN", "DOWN"}), "checks.findAll { it.name != 'failing-check' }.status.unique()", Matchers.contains((Object[])new String[]{"UP"})});
        }
        catch (Throwable throwable) {
            ((ValidatableResponse)((Response)RestAssured.given().queryParam("healthCheckEnabled", new Object[]{"false"}).post("/microprofile-health/failing-check", new Object[0])).then()).statusCode(204);
            throw throwable;
        }
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("healthCheckEnabled", new Object[]{"false"}).post("/microprofile-health/failing-check", new Object[0])).then()).statusCode(204);
    }

    @Test
    public void testLivenessUpStatus() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/q/health/live", new Object[0])).then()).contentType(ContentType.JSON)).header("Content-Type", Matchers.containsString((String)"charset=UTF-8"))).body("status", Matchers.is((Object)"UP"), new Object[]{"checks.status.findAll().unique()", Matchers.contains((Object[])new String[]{"UP"}), "checks.find { it.name == 'test-liveness' }.data.isLive as Boolean", Matchers.is((Object)true)});
    }

    @Test
    public void testLivenessDownStatus() {
        try {
            ((ValidatableResponse)((Response)RestAssured.given().queryParam("healthCheckEnabled", new Object[]{"true"}).post("/microprofile-health/failing-check", new Object[0])).then()).statusCode(204);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/q/health/live", new Object[0])).then()).contentType(ContentType.JSON)).header("Content-Type", Matchers.containsString((String)"charset=UTF-8"))).body("status", Matchers.is((Object)"DOWN"), new Object[]{"checks.find { it.name == 'failing-check' }.status", Matchers.is((Object)"DOWN"), "checks.findAll { it.name != 'failing-check' }.status.unique()", Matchers.contains((Object[])new String[]{"UP"})});
        }
        catch (Throwable throwable) {
            ((ValidatableResponse)((Response)RestAssured.given().queryParam("healthCheckEnabled", new Object[]{"false"}).post("/microprofile-health/failing-check", new Object[0])).then()).statusCode(204);
            throw throwable;
        }
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("healthCheckEnabled", new Object[]{"false"}).post("/microprofile-health/failing-check", new Object[0])).then()).statusCode(204);
    }

    @Test
    public void testReadinessUpStatus() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/q/health/ready", new Object[0])).then()).contentType(ContentType.JSON)).header("Content-Type", Matchers.containsString((String)"charset=UTF-8"))).body("status", Matchers.is((Object)"UP"), new Object[]{"checks.status.findAll().unique()", Matchers.contains((Object[])new String[]{"UP"}), "checks.find { it.name == 'test-readiness' }.data.isReady as Boolean", Matchers.is((Object)true)});
    }

    @Test
    public void testReadinessDownStatus() {
        try {
            ((ValidatableResponse)((Response)RestAssured.given().queryParam("healthCheckEnabled", new Object[]{"true"}).post("/microprofile-health/failing-check", new Object[0])).then()).statusCode(204);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/q/health/ready", new Object[0])).then()).contentType(ContentType.JSON)).header("Content-Type", Matchers.containsString((String)"charset=UTF-8"))).body("status", Matchers.is((Object)"DOWN"), new Object[]{"checks.find { it.name == 'failing-check' }.status", Matchers.is((Object)"DOWN"), "checks.findAll { it.name != 'failing-check' }.status.unique()", Matchers.contains((Object[])new String[]{"UP"})});
        }
        catch (Throwable throwable) {
            ((ValidatableResponse)((Response)RestAssured.given().queryParam("healthCheckEnabled", new Object[]{"false"}).post("/microprofile-health/failing-check", new Object[0])).then()).statusCode(204);
            throw throwable;
        }
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("healthCheckEnabled", new Object[]{"false"}).post("/microprofile-health/failing-check", new Object[0])).then()).statusCode(204);
    }

    @Test
    public void testRouteStoppedDownStatus() {
        try {
            ((ValidatableResponse)RestAssured.post((String)"/microprofile-health/route/healthyRoute/stop", (Object[])new Object[0]).then()).statusCode(204);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/q/health", new Object[0])).then()).contentType(ContentType.JSON)).header("Content-Type", Matchers.containsString((String)"charset=UTF-8"))).body("status", Matchers.is((Object)"DOWN"), new Object[]{"checks.find { it.name == 'camel-routes' }.status", Matchers.is((Object)"DOWN"), "checks.find { it.name == 'camel-routes' }.data.'route.id'", Matchers.is((Object)"healthyRoute"), "checks.find { it.name == 'camel-routes' }.data.'route.status'", Matchers.is((Object)ServiceStatus.Stopped.toString()), "checks.find { it.name == 'camel-consumers' }.status", Matchers.is((Object)"DOWN"), "checks.find { it.name == 'camel-consumers' }.data.'route.id'", Matchers.is((Object)"healthyRoute"), "checks.find { it.name == 'camel-consumers' }.data.'route.status'", Matchers.is((Object)ServiceStatus.Stopped.toString())});
        }
        finally {
            ((ValidatableResponse)RestAssured.post((String)"/microprofile-health/route/healthyRoute/start", (Object[])new Object[0]).then()).statusCode(204);
        }
    }
}

