/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.microprofile.it.faulttolerance;

import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;

@Path(value="/microprofile-fault-tolerance")
public class MicroprofileFaultToleranceResource {
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    CamelContext context;

    @Path(value="/route/{route}")
    @POST
    @Produces(value={"text/plain"})
    public String triggerFaultToleranceRoute(@PathParam(value="route") String route) {
        return (String)this.producerTemplate.requestBody("direct:" + route, null, String.class);
    }

    @Path(value="/faultToleranceWithThreshold/{route}")
    @POST
    @Produces(value={"text/plain"})
    public String faultToleranceWithThreshold(@PathParam(value="route") String route) {
        try {
            return (String)this.producerTemplate.requestBody("direct:" + route, null, String.class);
        }
        catch (Exception e) {
            return e.getCause().getMessage();
        }
    }

    @Path(value="/inheritErrorHandler")
    @POST
    public void inheritErrorHandler() throws Exception {
        MockEndpoint start = (MockEndpoint)this.context.getEndpoint("mock:start", MockEndpoint.class);
        start.expectedMessageCount(4);
        MockEndpoint end = (MockEndpoint)this.context.getEndpoint("mock:end", MockEndpoint.class);
        end.expectedMessageCount(0);
        MockEndpoint dead = (MockEndpoint)this.context.getEndpoint("mock:dead", MockEndpoint.class);
        dead.expectedMessageCount(1);
        this.producerTemplate.requestBody("direct:inheritErrorHandler", null, String.class);
        start.assertIsSatisfied(5000L);
        end.assertIsSatisfied(5000L);
        dead.assertIsSatisfied(5000L);
    }
}

