/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.microprofile.it.faulttolerance;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.CircuitBreakerDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.quarkus.component.microprofile.it.faulttolerance.GreetingBean;
import org.apache.camel.quarkus.component.microprofile.it.faulttolerance.MicroProfileFaultToleranceHelper;
import org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException;

@ApplicationScoped
public class MicroProfileFaultToleranceRoutes
extends RouteBuilder {
    public static final String EXCEPTION_MESSAGE = "Simulated Exception";
    public static final String FALLBACK_RESULT = "Fallback response";
    public static final String RESULT = "Hello Camel Quarkus MicroProfile Fault Tolerance";
    @Inject
    GreetingBean greetingBean;

    public void configure() throws Exception {
        ((ProcessorDefinition)((CircuitBreakerDefinition)this.from("direct:faultToleranceWithBulkhead").circuitBreaker().faultToleranceConfiguration().bulkheadEnabled(true).end().process(exchange -> {
            AtomicInteger counter = MicroProfileFaultToleranceHelper.getCounter("bulkhead");
            if (counter.incrementAndGet() == 1) {
                throw new IllegalStateException(EXCEPTION_MESSAGE);
            }
            exchange.getMessage().setBody((Object)RESULT);
        })).onFallback().setBody().constant((Object)FALLBACK_RESULT)).end();
        ((ProcessorDefinition)((CircuitBreakerDefinition)this.from("direct:faultToleranceWithFallback").circuitBreaker().process(exchange -> {
            AtomicInteger counter = MicroProfileFaultToleranceHelper.getCounter("fallback");
            if (counter.incrementAndGet() == 1) {
                throw new IllegalStateException(EXCEPTION_MESSAGE);
            }
            exchange.getMessage().setBody((Object)RESULT);
        })).onFallback().setBody().constant((Object)FALLBACK_RESULT)).end();
        ((CircuitBreakerDefinition)this.from("direct:faultToleranceWithThreshold").circuitBreaker().faultToleranceConfiguration().failureRatio(100).successThreshold(1).requestVolumeThreshold(1).delay(0L).end().process(exchange -> {
            AtomicInteger counter = MicroProfileFaultToleranceHelper.getCounter("threshold");
            if (counter.incrementAndGet() == 1) {
                throw new IllegalStateException(EXCEPTION_MESSAGE);
            }
            exchange.getMessage().setBody((Object)"Nothing to see here. Circuit breaker is open...");
        })).end().setBody().simple(RESULT);
        ((ProcessorDefinition)((CircuitBreakerDefinition)this.from("direct:faultToleranceWithTimeout").circuitBreaker().faultToleranceConfiguration().timeoutEnabled(true).timeoutDuration(500L).end().process(exchange -> {
            AtomicInteger counter = MicroProfileFaultToleranceHelper.getCounter("timeout");
            if (counter.incrementAndGet() == 1) {
                Thread.sleep(1000L);
            }
            exchange.getMessage().setBody((Object)RESULT);
        })).onFallback().setBody().simple(FALLBACK_RESULT)).end();
        ((ProcessorDefinition)((CircuitBreakerDefinition)this.from("direct:faultToleranceWithTimeoutCustomExecutor").circuitBreaker().faultToleranceConfiguration().timeoutEnabled(true).timeoutScheduledExecutorService("myThreadPool").timeoutDuration(500L).end().process(exchange -> {
            AtomicInteger counter = MicroProfileFaultToleranceHelper.getCounter("timeoutCustomExecutor");
            if (counter.incrementAndGet() == 1) {
                Thread.sleep(1000L);
            }
            exchange.getMessage().setBody((Object)RESULT);
        })).onFallback().setBody().simple(FALLBACK_RESULT)).end();
        ((CircuitBreakerDefinition)((CircuitBreakerDefinition)((CircuitBreakerDefinition)this.from("direct:inheritErrorHandler").errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead").maximumRedeliveries(3).redeliveryDelay(0L)).circuitBreaker().inheritErrorHandler(true)).to("mock:start")).throwException((Exception)new IllegalArgumentException(EXCEPTION_MESSAGE))).end().to("mock:end");
        this.from("direct:circuitBreakerBean").bean((Object)this.greetingBean, "greetWithCircuitBreaker");
        this.from("direct:fallbackBean").bean((Object)this.greetingBean, "greetWithFallback");
        ((ProcessorDefinition)((TryDefinition)this.from("direct:timeoutBean").doTry().bean((Object)this.greetingBean, "greetWithDelay")).doCatch(TimeoutException.class).setBody().constant((Object)FALLBACK_RESULT)).end();
    }

    @Named(value="myThreadPool")
    public ScheduledExecutorService myThreadPool() {
        return this.getCamelContext().getExecutorServiceManager().newScheduledThreadPool((Object)this, "myThreadPool", 2);
    }
}

