/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.microprofile.it.faulttolerance;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.ValidatableResponse;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

@QuarkusTest
class MicroprofileFaultToleranceTest {
    MicroprofileFaultToleranceTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"routeUris"})
    public void testCamelMicroProfileFaultTolerance(String route) {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.post((String)("/microprofile-fault-tolerance/route/" + route), (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"Fallback response"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.post((String)("/microprofile-fault-tolerance/route/" + route), (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"Hello Camel Quarkus MicroProfile Fault Tolerance"), new Matcher[0]);
    }

    @ParameterizedTest
    @ValueSource(strings={"faultToleranceWithThreshold", "circuitBreakerBean"})
    public void testCamelMicroProfileFaultToleranceWithThreshold(String route) {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.post((String)("/microprofile-fault-tolerance/faultToleranceWithThreshold/" + route), (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"Simulated Exception"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.post((String)("/microprofile-fault-tolerance/faultToleranceWithThreshold/" + route), (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)"Hello Camel Quarkus MicroProfile Fault Tolerance"), new Matcher[0]);
    }

    @Test
    public void testCamelMicroProfileFaultToleranceInheritErrorHandler() {
        ((ValidatableResponse)RestAssured.post((String)"/microprofile-fault-tolerance/inheritErrorHandler", (Object[])new Object[0]).then()).statusCode(204);
    }

    public static String[] routeUris() {
        return new String[]{"faultToleranceWithFallback", "faultToleranceWithBulkhead", "faultToleranceWithTimeout", "faultToleranceWithTimeoutCustomExecutor", "fallbackBean", "timeoutBean"};
    }
}

