/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.microprofile.it.metrics;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.AdviceWithRouteBuilder;

@Path(value="/microprofile-metrics")
@ApplicationScoped
public class MicroProfileMetricsResource {
    @Inject
    ProducerTemplate template;
    @Inject
    CamelContext context;

    @Path(value="/counter")
    @GET
    public Response counterIncrement() throws Exception {
        this.template.sendBody("direct:counter", null);
        return Response.ok().build();
    }

    @Path(value="/gauge/concurrent/increment")
    @GET
    public Response gaugeIncrement() throws Exception {
        this.template.sendBody("direct:concurrentGaugeIncrement", null);
        return Response.ok().build();
    }

    @Path(value="/gauge/concurrent/decrement")
    @GET
    public Response gaugeDecrement() throws Exception {
        this.template.sendBody("direct:concurrentGaugeDecrement", null);
        return Response.ok().build();
    }

    @Path(value="/gauge")
    @GET
    public Response gaugeSetValue(@QueryParam(value="value") int value) throws Exception {
        this.template.sendBody("direct:gauge", (Object)value);
        return Response.ok().build();
    }

    @Path(value="/histogram")
    @GET
    public Response histogramSetValue(@QueryParam(value="value") int value) throws Exception {
        this.template.sendBody("direct:histogram", (Object)value);
        return Response.ok().build();
    }

    @Path(value="/meter")
    @GET
    public Response meterSetMark(@QueryParam(value="mark") int mark) throws Exception {
        this.template.sendBody("direct:meter", (Object)mark);
        return Response.ok().build();
    }

    @Path(value="/timer")
    @GET
    public Response timerStartStop() throws Exception {
        this.template.sendBody("direct:timer", null);
        return Response.ok().build();
    }

    @Path(value="/log")
    @GET
    public Response logMessage() throws Exception {
        this.template.sendBody("log:message", (Object)"Test log message");
        return Response.ok().build();
    }

    @Path(value="/advicewith")
    @GET
    public Response adviceWith() throws Exception {
        AdviceWithRouteBuilder.adviceWith((CamelContext)this.context, (Object)"log", advisor -> advisor.replaceFromWith("direct:replaced"));
        return Response.ok().build();
    }

    @Path(value="/processor")
    @GET
    public Response countedProcessor() {
        this.template.sendBody("direct:processorMetrics", (Object)"Hello World");
        return Response.ok().build();
    }
}

