/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.microprofile.it.faulttolerance;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.CircuitBreakerDefinition;
import org.apache.camel.model.ProcessorDefinition;

public class MicroProfileFaultToleranceRoutes
extends RouteBuilder {
    public static final String FALLBACK_RESULT = "Fallback response";
    public static final String RESULT = "Hello Camel Quarkus MicroProfile Fault Tolerance";
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private static final AtomicInteger TIMEOUT_COUNTER = new AtomicInteger();

    public void configure() throws Exception {
        ((ProcessorDefinition)((CircuitBreakerDefinition)this.from("direct:faultTolerance").circuitBreaker().process(exchange -> {
            if (COUNTER.incrementAndGet() == 1) {
                throw new IllegalStateException("Simulated Exception");
            }
            exchange.getMessage().setBody((Object)RESULT);
        })).onFallback().setBody().constant((Object)FALLBACK_RESULT)).end();
        ((ProcessorDefinition)((CircuitBreakerDefinition)this.from("direct:faultToleranceWithTimeout").circuitBreaker().faultToleranceConfiguration().timeoutEnabled(true).timeoutDuration(500L).end().process(exchange -> {
            if (TIMEOUT_COUNTER.incrementAndGet() == 1) {
                Thread.sleep(1000L);
            }
            exchange.getMessage().setBody((Object)("Regular hi " + (String)exchange.getMessage().getBody(String.class)));
        })).onFallback().setBody().simple("Sorry ${body}, had to fallback!")).end();
    }
}

