/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.microprofile.it.metrics;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Map;
import org.apache.camel.ServiceStatus;
import org.apache.camel.quarkus.component.microprofile.it.metrics.CountedProcessor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
class MicroProfileMetricsTest {
    private static final String CAMEL_CONTEXT_METRIC_TAG = ";camelContext=quarkus-camel-example";

    MicroProfileMetricsTest() {
    }

    @Test
    public void testMicroProfileMetricsCounter() {
        ((ValidatableResponse)RestAssured.get((String)"/microprofile-metrics/counter", (Object[])new Object[0]).then()).statusCode(200);
        Assertions.assertEquals((int)1, (int)this.getMetricIntValue("camel-quarkus-counter", new String[0]));
    }

    @Test
    public void testMicroProfileMetricsConcurrentGauge() {
        int i;
        for (i = 0; i < 10; ++i) {
            ((ValidatableResponse)RestAssured.get((String)"/microprofile-metrics/gauge/concurrent/increment", (Object[])new Object[0]).then()).statusCode(200);
        }
        Assertions.assertEquals((int)10, (int)this.getMetricIntValue("camel-quarkus-concurrent-gauge.current", new String[0]));
        for (i = 0; i < 3; ++i) {
            ((ValidatableResponse)RestAssured.get((String)"/microprofile-metrics/gauge/concurrent/decrement", (Object[])new Object[0]).then()).statusCode(200);
        }
        Assertions.assertEquals((int)7, (int)this.getMetricIntValue("camel-quarkus-concurrent-gauge.current", new String[0]));
    }

    @Test
    public void testMicroProfileMetricsGauge() {
        ((ValidatableResponse)RestAssured.get((String)"/microprofile-metrics/gauge?value=10", (Object[])new Object[0]).then()).statusCode(200);
        Assertions.assertEquals((int)10, (int)this.getMetricIntValue("camel-quarkus-gauge", new String[0]));
    }

    @Test
    public void testMicroProfileMetricsHistogram() {
        ((ValidatableResponse)RestAssured.get((String)"/microprofile-metrics/histogram?value=10", (Object[])new Object[0]).then()).statusCode(200);
        Assertions.assertEquals((int)10, (int)this.getMetricIntValue("camel-quarkus-histogram.max", new String[0]));
    }

    @Test
    public void testMicroProfileMetricsMeter() {
        ((ValidatableResponse)RestAssured.get((String)"/microprofile-metrics/meter?mark=10", (Object[])new Object[0]).then()).statusCode(200);
        Assertions.assertEquals((int)10, (int)this.getMetricIntValue("camel-quarkus-meter.count", new String[0]));
    }

    @Test
    public void testMicroProfileMetricsTimer() {
        ((ValidatableResponse)RestAssured.get((String)"/microprofile-metrics/timer", (Object[])new Object[0]).then()).statusCode(200);
        Assertions.assertTrue(((double)this.getMetricFloatValue("camel-quarkus-timer.max", new String[0]) > 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void testMicroProfileMetricsRoutePolicyFactory() {
        ((ValidatableResponse)RestAssured.get((String)"/microprofile-metrics/timer", (Object[])new Object[0]).then()).statusCode(200);
        Assertions.assertTrue((this.getMetricIntValue("camel.route.exchanges.total", CAMEL_CONTEXT_METRIC_TAG, "routeId=mp-metrics-timer") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMicroProfileMetricsMessageHistoryFactory() {
        ((ValidatableResponse)RestAssured.get((String)"/microprofile-metrics/log", (Object[])new Object[0]).then()).statusCode(200);
        Map exchangeMetrics = this.getApplicationMetrics().getMap("'camel.message.history.processing'");
        exchangeMetrics.forEach((k, v) -> {
            if (k.startsWith("total")) {
                Assertions.assertTrue(((Integer)v > 0 ? 1 : 0) != 0);
            }
        });
    }

    @Test
    public void testMicroProfileMetricsRouteEventNotifier() {
        Assertions.assertTrue((this.getMetricIntValue("camel.route.count", new String[0]) >= 7 ? 1 : 0) != 0);
        Assertions.assertTrue((this.getMetricIntValue("camel.route.running.count", new String[0]) >= 7 ? 1 : 0) != 0);
    }

    @Test
    public void testMicroProfileMetricsExchangeEventNotifier() {
        ((ValidatableResponse)RestAssured.get((String)"/microprofile-metrics/log", (Object[])new Object[0]).then()).statusCode(200);
        Assertions.assertTrue((this.getMetricIntValue("camel.context.exchanges.total", new String[0]) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMicroProfileMetricsCamelContextEventNotifier() {
        Assertions.assertEquals((int)ServiceStatus.Started.ordinal(), (int)this.getMetricIntValue("camel.context.status", new String[0]));
        Assertions.assertTrue((this.getMetricIntValue("camel.context.uptime", new String[0]) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAdviceWith() {
        ((ValidatableResponse)RestAssured.get((String)"/microprofile-metrics/advicewith", (Object[])new Object[0]).then()).statusCode(200);
        Assertions.assertTrue((this.getMetricIntValue("camel.route.count", new String[0]) >= 7 ? 1 : 0) != 0);
        Assertions.assertTrue((this.getMetricIntValue("camel.route.running.count", new String[0]) >= 7 ? 1 : 0) != 0);
    }

    @Test
    public void testCountedProcessor() {
        for (int i = 0; i < 5; ++i) {
            ((ValidatableResponse)RestAssured.get((String)"/microprofile-metrics/processor", (Object[])new Object[0]).then()).statusCode(200);
        }
        int result = this.getApplicationMetrics().getInt("'" + CountedProcessor.class.getName() + ".custom.processor.count'");
        Assertions.assertEquals((int)5, (int)result);
    }

    private int getMetricIntValue(String metricName, String ... tags) {
        return this.getApplicationMetrics().getInt(this.sanitizeMetricName(metricName, tags));
    }

    private float getMetricFloatValue(String metricName, String ... tags) {
        return this.getApplicationMetrics().getFloat(this.sanitizeMetricName(metricName, tags));
    }

    private String sanitizeMetricName(String metricName, String ... tags) {
        if (tags.length == 0) {
            tags = new String[]{CAMEL_CONTEXT_METRIC_TAG};
        }
        if (metricName.contains(".") && metricName.split("\\.").length > 2) {
            return String.format("'%s%s'", metricName, String.join((CharSequence)";", tags));
        }
        return metricName + String.join((CharSequence)";", tags);
    }

    private JsonPath getApplicationMetrics() {
        return ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept("application/json").get("/q/metrics/application", new Object[0])).then()).statusCode(200)).extract().body().jsonPath();
    }
}

