/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.microprofile.it.health;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@QuarkusTest
class MicroProfileHealthTest {
    MicroProfileHealthTest() {
    }

    @Test
    public void testHealthUpStatus() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/q/health", new Object[0])).then()).contentType(ContentType.JSON)).header("Content-Type", Matchers.containsString((String)"charset=UTF-8"))).body("status", Matchers.is((Object)"UP"), new Object[]{"checks.status", Matchers.containsInAnyOrder((Object[])new String[]{"UP", "UP"}), "checks.name", Matchers.containsInAnyOrder((Object[])new String[]{"camel-readiness-checks", "camel-liveness-checks"}), "checks.data.context", Matchers.containsInAnyOrder((Object[])new String[]{null, "UP"}), "checks.data.'route:healthyRoute'", Matchers.containsInAnyOrder((Object[])new String[]{null, "UP"}), "checks.data.always-up", Matchers.containsInAnyOrder((Object[])new String[]{"UP", "UP"})});
    }

    @Test
    public void testHealthDownStatus() {
        try {
            ((ValidatableResponse)RestAssured.get((String)"/microprofile-health/checks/failing/true", (Object[])new Object[0]).then()).statusCode(204);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/q/health", new Object[0])).then()).contentType(ContentType.JSON)).header("Content-Type", Matchers.containsString((String)"charset=UTF-8"))).body("status", Matchers.is((Object)"DOWN"), new Object[]{"checks.status", Matchers.containsInAnyOrder((Object[])new String[]{"DOWN", "DOWN"}), "checks.name", Matchers.containsInAnyOrder((Object[])new String[]{"camel-readiness-checks", "camel-liveness-checks"}), "checks.data.context", Matchers.containsInAnyOrder((Object[])new String[]{null, "UP"})});
        }
        finally {
            ((ValidatableResponse)RestAssured.get((String)"/microprofile-health/checks/failing/false", (Object[])new Object[0]).then()).statusCode(204);
        }
    }

    @Test
    public void testLivenessUpStatus() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/q/health/live", new Object[0])).then()).contentType(ContentType.JSON)).header("Content-Type", Matchers.containsString((String)"charset=UTF-8"))).body("status", Matchers.is((Object)"UP"), new Object[]{"checks.status", Matchers.containsInAnyOrder((Object[])new String[]{"UP"}), "checks.name", Matchers.containsInAnyOrder((Object[])new String[]{"camel-liveness-checks"}), "checks.data.test", Matchers.containsInAnyOrder((Object[])new String[]{"UP"}), "checks.data.test-liveness", Matchers.containsInAnyOrder((Object[])new String[]{"UP"})});
    }

    @Test
    public void testLivenessDownStatus() {
        try {
            ((ValidatableResponse)RestAssured.get((String)"/microprofile-health/checks/failing/true", (Object[])new Object[0]).then()).statusCode(204);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/q/health/live", new Object[0])).then()).contentType(ContentType.JSON)).header("Content-Type", Matchers.containsString((String)"charset=UTF-8"))).body("status", Matchers.is((Object)"DOWN"), new Object[]{"checks.status", Matchers.containsInAnyOrder((Object[])new String[]{"DOWN"}), "checks.name", Matchers.containsInAnyOrder((Object[])new String[]{"camel-liveness-checks"}), "checks.data.test", Matchers.containsInAnyOrder((Object[])new String[]{"UP"}), "checks.data.test-liveness", Matchers.containsInAnyOrder((Object[])new String[]{"UP"}), "checks.data.failing-check", Matchers.containsInAnyOrder((Object[])new String[]{"DOWN"})});
        }
        finally {
            ((ValidatableResponse)RestAssured.get((String)"/microprofile-health/checks/failing/false", (Object[])new Object[0]).then()).statusCode(204);
        }
    }

    @Test
    public void testReadinessUpStatus() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/q/health/ready", new Object[0])).then()).contentType(ContentType.JSON)).header("Content-Type", Matchers.containsString((String)"charset=UTF-8"))).body("status", Matchers.is((Object)"UP"), new Object[]{"checks.status", Matchers.containsInAnyOrder((Object[])new String[]{"UP"}), "checks.name", Matchers.containsInAnyOrder((Object[])new String[]{"camel-readiness-checks"}), "checks.data.context", Matchers.containsInAnyOrder((Object[])new String[]{"UP"}), "checks.data.test-readiness", Matchers.containsInAnyOrder((Object[])new String[]{"UP"})});
    }

    @Test
    public void testReadinessDownStatus() {
        try {
            ((ValidatableResponse)RestAssured.get((String)"/microprofile-health/checks/failing/true", (Object[])new Object[0]).then()).statusCode(204);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/q/health/ready", new Object[0])).then()).contentType(ContentType.JSON)).header("Content-Type", Matchers.containsString((String)"charset=UTF-8"))).body("status", Matchers.is((Object)"DOWN"), new Object[]{"checks.status", Matchers.containsInAnyOrder((Object[])new String[]{"DOWN"}), "checks.name", Matchers.containsInAnyOrder((Object[])new String[]{"camel-readiness-checks"}), "checks.data.context", Matchers.containsInAnyOrder((Object[])new String[]{"UP"}), "checks.data.test-readiness", Matchers.containsInAnyOrder((Object[])new String[]{"UP"})});
        }
        finally {
            ((ValidatableResponse)RestAssured.get((String)"/microprofile-health/checks/failing/false", (Object[])new Object[0]).then()).statusCode(204);
        }
    }

    @Test
    public void testRouteStoppedDownStatus() {
        try {
            ((ValidatableResponse)RestAssured.get((String)"/microprofile-health/route/healthyRoute/stop", (Object[])new Object[0]).then()).statusCode(204);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/q/health", new Object[0])).then()).contentType(ContentType.JSON)).header("Content-Type", Matchers.containsString((String)"charset=UTF-8"))).body("status", Matchers.is((Object)"DOWN"), new Object[]{"checks.data.'route:healthyRoute'", Matchers.containsInAnyOrder((Object[])new String[]{null, "DOWN"})});
        }
        finally {
            ((ValidatableResponse)RestAssured.get((String)"/microprofile-health/route/healthyRoute/start", (Object[])new Object[0]).then()).statusCode(204);
        }
    }

    @Disabled(value="https://github.com/apache/camel-quarkus/issues/3277")
    @Test
    public void testFailureThreshold() {
        try {
            ((ValidatableResponse)RestAssured.get((String)"/microprofile-health/route/checkIntervalThreshold/stop", (Object[])new Object[0]).then()).statusCode(204);
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/q/health", new Object[0])).then()).contentType(ContentType.JSON)).header("Content-Type", Matchers.containsString((String)"charset=UTF-8"))).body("status", Matchers.is((Object)"UP"), new Object[]{"checks.data.'route:checkIntervalThreshold'", Matchers.containsInAnyOrder((Object[])new String[]{null, "UP"})});
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).pollDelay(50L, TimeUnit.MILLISECONDS).until(() -> {
                JsonPath result = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/q/health", new Object[0])).then()).contentType(ContentType.JSON)).header("Content-Type", Matchers.containsString((String)"charset=UTF-8"))).extract().jsonPath();
                String status = result.getString("status");
                List routeStatus = result.getList("checks.data.'route:checkIntervalThreshold'");
                return status.equals("DOWN") && routeStatus.contains("DOWN");
            });
        }
        finally {
            ((ValidatableResponse)RestAssured.get((String)"/microprofile-health/route/checkIntervalThreshold/start", (Object[])new Object[0]).then()).statusCode(204);
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).pollDelay(50L, TimeUnit.MILLISECONDS).until(() -> {
                JsonPath result = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/q/health", new Object[0])).then()).contentType(ContentType.JSON)).header("Content-Type", Matchers.containsString((String)"charset=UTF-8"))).extract().jsonPath();
                String status = result.getString("status");
                List routeStatus = result.getList("checks.data.'route:checkIntervalThreshold'");
                return status.equals("UP") && routeStatus.contains("UP");
            });
        }
    }
}

