/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.microprofile.it.health;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.camel.CamelContext;
import org.apache.camel.health.HealthCheckRegistry;

@Path(value="/microprofile-health")
@ApplicationScoped
public class MicroProfileHealthResource {
    @Inject
    CamelContext camelContext;

    @Path(value="/route/{routeId}/stop")
    @POST
    public void stopCamelRoute(@PathParam(value="routeId") String routeId) throws Exception {
        this.camelContext.getRouteController().stopRoute(routeId);
    }

    @Path(value="/route/{routeId}/start")
    @POST
    public void startCamelRoute(@PathParam(value="routeId") String routeId) throws Exception {
        this.camelContext.getRouteController().startRoute(routeId);
    }

    @Path(value="/{healthCheckId}")
    @POST
    public void healthCheckEnabled(@PathParam(value="healthCheckId") String healthCheckId, @QueryParam(value="healthCheckEnabled") boolean isHealthCheckEnabled) {
        HealthCheckRegistry registry = (HealthCheckRegistry)this.camelContext.getExtension(HealthCheckRegistry.class);
        registry.getCheck(healthCheckId).ifPresent(healthCheck -> {
            healthCheck.setEnabled(isHealthCheckEnabled);
            if (isHealthCheckEnabled) {
                registry.register(healthCheck);
            } else {
                registry.unregister(healthCheck);
            }
        });
    }
}

