/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.microprofile.it.faulttolerance;

import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.ApplicationScoped;
import org.apache.camel.quarkus.component.microprofile.it.faulttolerance.MicroProfileFaultToleranceHelper;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Timeout;

@ApplicationScoped
public class GreetingBean {
    @Fallback(fallbackMethod="fallbackGreeting")
    public String greetWithFallback() {
        AtomicInteger counter = MicroProfileFaultToleranceHelper.getCounter("beanFallback");
        if (counter.incrementAndGet() == 1) {
            throw new IllegalStateException("Simulated Exception");
        }
        return "Hello Camel Quarkus MicroProfile Fault Tolerance";
    }

    @Timeout(value=250L)
    public String greetWithDelay() throws InterruptedException {
        AtomicInteger counter = MicroProfileFaultToleranceHelper.getCounter("beanTimeout");
        if (counter.incrementAndGet() == 1) {
            Thread.sleep(500L);
            return "Nothing to see here, method invocation timed out!";
        }
        return "Hello Camel Quarkus MicroProfile Fault Tolerance";
    }

    @CircuitBreaker(failureRatio=1.0, requestVolumeThreshold=1, delay=0L)
    public String greetWithCircuitBreaker() {
        AtomicInteger counter = MicroProfileFaultToleranceHelper.getCounter("beanThreshold");
        if (counter.incrementAndGet() == 1) {
            throw new IllegalStateException("Simulated Exception");
        }
        return "Hello Camel Quarkus MicroProfile Fault Tolerance";
    }

    public String fallbackGreeting() {
        return "Fallback response";
    }
}

