/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.microprofile.it.health;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.apache.camel.CamelContext;
import org.apache.camel.quarkus.component.microprofile.it.health.FailingHealthCheck;
import org.apache.camel.spi.Registry;

@Path(value="/microprofile-health")
@ApplicationScoped
public class MicroProfileHealthResource {
    @Inject
    CamelContext camelContext;

    @Path(value="/checks/failing/{enabled}")
    @GET
    public void toggleFailingHealthCheck(@PathParam(value="enabled") boolean enabled) {
        Registry registry = this.camelContext.getRegistry();
        FailingHealthCheck failingHealthCheck = (FailingHealthCheck)((Object)registry.lookupByNameAndType(FailingHealthCheck.class.getSimpleName(), FailingHealthCheck.class));
        failingHealthCheck.getConfiguration().setEnabled(enabled);
    }

    @Path(value="/route/{routeId}/stop")
    @GET
    public void stopCamelRoute(@PathParam(value="routeId") String routeId) throws Exception {
        this.camelContext.getRouteController().stopRoute(routeId);
    }

    @Path(value="/route/{routeId}/start")
    @GET
    public void startCamelRoute(@PathParam(value="routeId") String routeId) throws Exception {
        this.camelContext.getRouteController().startRoute(routeId);
    }
}

