/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.micrometer.it;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.search.Search;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.camel.ProducerTemplate;

@Path(value="/micrometer")
public class MicrometerResource {
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    MeterRegistry meterRegistry;

    @Path(value="/metric/{type}/{name}")
    @Produces(value={"application/json"})
    @GET
    public Response getMetricValue(@PathParam(value="type") String type, @PathParam(value="name") String name, @QueryParam(value="tags") String tagValues) {
        Search search;
        ArrayList<Tag> tags = new ArrayList<Tag>();
        if (tagValues.length() > 0) {
            String[] tagElements;
            for (String element : tagElements = tagValues.split(",")) {
                String[] tagParts = element.split("=");
                tags.add(Tag.of((String)tagParts[0], (String)tagParts[1]));
            }
        }
        if ((search = this.meterRegistry.find(name).tags(tags)) == null) {
            return Response.status((int)404).build();
        }
        Response.ResponseBuilder response = Response.ok();
        if (type.equals("counter")) {
            response.entity((Object)search.counter().count());
        } else if (type.equals("gauge")) {
            response.entity((Object)search.gauge().value());
        } else if (type.equals("summary")) {
            response.entity((Object)search.summary().max());
        } else if (type.equals("timer")) {
            response.entity((Object)search.timer().totalTime(TimeUnit.MILLISECONDS));
        } else {
            throw new IllegalArgumentException("Unknown metric type: " + type);
        }
        return response.build();
    }

    @Path(value="/counter")
    @GET
    public Response counter() {
        this.producerTemplate.sendBody("direct:counter", null);
        return Response.ok().build();
    }

    @Path(value="/summary")
    @GET
    public Response summarySetValue(@QueryParam(value="value") int value) {
        this.producerTemplate.sendBody("direct:summary", (Object)value);
        return Response.ok().build();
    }

    @Path(value="/timer")
    @GET
    public Response timerStartStop() {
        this.producerTemplate.sendBody("direct:timer", null);
        return Response.ok().build();
    }

    @Path(value="/log")
    @GET
    public Response logMessage() {
        this.producerTemplate.requestBody("direct:log", null);
        return Response.ok().build();
    }
}

