/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.micrometer.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
class MicrometerTest {
    MicrometerTest() {
    }

    @Test
    public void testMicrometerMetricsCounter() {
        ((ValidatableResponse)RestAssured.get((String)"/micrometer/counter", (Object[])new Object[0]).then()).statusCode(200);
        Assertions.assertEquals((int)1, (Integer)this.getMetricValue(Integer.class, "counter", "camel-quarkus-counter"));
    }

    @Test
    public void testMicrometerSummary() {
        ((ValidatableResponse)RestAssured.get((String)"/micrometer/summary?value=10", (Object[])new Object[0]).then()).statusCode(200);
        Assertions.assertEquals((int)10, (Integer)this.getMetricValue(Integer.class, "summary", "camel-quarkus-summary"));
    }

    @Test
    public void testMicrometerTimer() {
        ((ValidatableResponse)RestAssured.get((String)"/micrometer/timer", (Object[])new Object[0]).then()).statusCode(200);
        Assertions.assertTrue((this.getMetricValue(Integer.class, "timer", "camel-quarkus-timer") >= 100 ? 1 : 0) != 0);
    }

    @Test
    public void testMicrometerRoutePolicyFactory() {
        ((ValidatableResponse)RestAssured.get((String)"/micrometer/timer", (Object[])new Object[0]).then()).statusCode(200);
        Assertions.assertTrue((this.getMetricValue(Integer.class, "counter", "CamelExchangesSucceeded", "routeId=micrometer-metrics-timer") > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (Integer)this.getMetricValue(Integer.class, "counter", "CamelExchangesFailed", "routeId=micrometer-metrics-timer"));
    }

    @Test
    public void testMicrometerMessageHistoryFactory() {
        ((ValidatableResponse)RestAssured.get((String)"/micrometer/log", (Object[])new Object[0]).then()).statusCode(200);
        String tags = "nodeId=log1,routeId=log";
        Assertions.assertTrue((this.getMetricValue(Double.class, "timer", "CamelMessageHistory", tags) > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testMicrometerRouteEventNotifier() {
        Assertions.assertTrue((this.getMetricValue(Integer.class, "gauge", "CamelRoutesAdded") >= 4 ? 1 : 0) != 0);
        Assertions.assertTrue((this.getMetricValue(Integer.class, "gauge", "CamelRoutesRunning") >= 4 ? 1 : 0) != 0);
    }

    @Test
    public void testMicrometerExchangeEventNotifier() {
        ((ValidatableResponse)RestAssured.get((String)"/micrometer/log", (Object[])new Object[0]).then()).statusCode(200);
        String tags = "endpointName=direct://log,eventType=ExchangeSentEvent";
        Assertions.assertTrue((this.getMetricValue(Double.class, "timer", "CamelExchangeEventNotifier", tags) >= 0.0 ? 1 : 0) != 0);
    }

    private <T> T getMetricValue(Class<T> as, String type, String name) {
        return this.getMetricValue(as, type, name, null);
    }

    private <T> T getMetricValue(Class<T> as, String type, String name, String tags) {
        return (T)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("tags", new Object[]{tags}).when().get("/micrometer/metric/" + type + "/" + name, new Object[0])).then()).statusCode(200)).extract().body().as(as);
    }

    private String dumpMetrics() {
        return ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/metrics", (Object[])new Object[0]).then()).statusCode(200)).extract().body().asString();
    }
}

