/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.messaging.sjms;

import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.quarkus.component.messaging.it.util.scheme.ComponentScheme;

@Path(value="/messaging/sjms")
public class SjmsResource {
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    CamelContext context;
    @Inject
    ComponentScheme componentScheme;

    @Path(value="/selector")
    @GET
    public void jmsSelector() throws InterruptedException {
        MockEndpoint mockEndpoint = (MockEndpoint)this.context.getEndpoint("mock:selectorResult", MockEndpoint.class);
        mockEndpoint.expectedBodiesReceived(new Object[]{"Camel SJMS Selector Match"});
        String uri = String.valueOf(this.componentScheme) + ":queue:selectorA";
        this.producerTemplate.sendBodyAndHeader(uri, (Object)"Camel SJMS Selector Not Matched", "foo", (Object)"baz");
        this.producerTemplate.sendBodyAndHeader(uri, (Object)"Camel SJMS Selector Match", "foo", (Object)"bar");
        mockEndpoint.assertIsSatisfied(5000L);
    }

    @Path(value="/custom/destination/{destinationName}")
    @POST
    public Response produceMessageWithCustomDestination(@PathParam(value="destinationName") String destinationName, String message) throws Exception {
        this.producerTemplate.sendBodyAndHeader("direct:computedDestination", (Object)message, "DestinationName", (Object)destinationName);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }
}

