/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.messaging.sjms;

import java.net.URI;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.quarkus.component.messaging.it.util.scheme.ComponentScheme;

@Path(value="/messaging/sjms")
public class SjmsResource {
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    CamelContext context;
    @Inject
    ComponentScheme componentScheme;

    @Path(value="/selector")
    @GET
    public void jmsSelector() throws InterruptedException {
        MockEndpoint mockEndpoint = (MockEndpoint)this.context.getEndpoint("mock:selectorResult", MockEndpoint.class);
        mockEndpoint.expectedBodiesReceived(new Object[]{"Camel SJMS Selector Match"});
        String uri = this.componentScheme + ":queue:selectorA";
        this.producerTemplate.sendBodyAndHeader(uri, (Object)"Camel SJMS Selector Not Matched", "foo", (Object)"baz");
        this.producerTemplate.sendBodyAndHeader(uri, (Object)"Camel SJMS Selector Match", "foo", (Object)"bar");
        mockEndpoint.assertIsSatisfied(5000L);
    }

    @Path(value="/custom/destination/{destinationName}")
    @POST
    public Response produceMessageWithCustomDestination(@PathParam(value="destinationName") String destinationName, String message) throws Exception {
        this.producerTemplate.sendBodyAndHeader("direct:computedDestination", (Object)message, "DestinationName", (Object)destinationName);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }
}

