/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.messaging.jms;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.TransactedDefinition;
import org.apache.camel.quarkus.component.messaging.it.util.scheme.ComponentScheme;
import org.apache.camel.quarkus.messaging.jms.DummyXAResource;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;

@ApplicationScoped
public class JmsRoutes
extends RouteBuilder {
    @Inject
    ComponentScheme componentScheme;
    @Inject
    TransactionManager transactionManager;

    public void configure() throws Exception {
        this.fromF("%s:queue:testJmsTransferExchange?transferExchange=true", new Object[]{this.componentScheme}).to("mock:transferExchangeResult");
        this.fromF("%s:queue:testJmsTransferException?transferException=true", new Object[]{this.componentScheme}).throwException((Exception)new IllegalStateException("Forced exception"));
        ((RouteDefinition)this.from("direct:computedDestination").bean((Object)"destinationHeaderSetter")).toF("%s:queue:override", new Object[]{this.componentScheme});
        ((RouteDefinition)this.fromF("%s:queue:xa?transactionManager=#jtaTransactionManager", new Object[]{this.componentScheme}).routeId("xaConsumer").log("Received message ${body}")).to("mock:xaResult");
        ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((TransactedDefinition)((TransactedDefinition)this.from("direct:xa").routeId("xa").transacted().process(x -> this.transactionManager.getTransaction().enlistResource((XAResource)new DummyXAResource()))).toF("%s:queue:xa?disableReplyTo=true", new Object[]{this.componentScheme})).choice().when(this.body().startsWith((Object)"fail")).log("Forced to rollback")).process(x -> this.transactionManager.setRollbackOnly())).otherwise().log("Message added: ${body}")).endChoice();
    }

    @Named(value="jtaTransactionManager")
    public PlatformTransactionManager getTransactionManager() {
        return new JtaTransactionManager(this.transactionManager);
    }
}

