/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.messaging.jms;

import jakarta.inject.Inject;
import jakarta.jms.Destination;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.quarkus.component.messaging.it.util.scheme.ComponentScheme;

@Path(value="/messaging/jms")
public class JmsResource {
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;
    @Inject
    CamelContext context;
    @Inject
    ComponentScheme componentScheme;

    @Path(value="/{queueName}/custom/message/listener/factory")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String customMessageListenerContainerFactory(@PathParam(value="queueName") String queueName, String message) {
        this.producerTemplate.sendBody(String.valueOf(this.componentScheme) + ":queue:" + queueName + "?messageListenerContainerFactory=#customMessageListener", (Object)message);
        return (String)this.consumerTemplate.receiveBody(String.valueOf(this.componentScheme) + ":queue:" + queueName, 5000L, String.class);
    }

    @Path(value="/custom/destination/resolver")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String customDestinationResolver(String message) {
        this.producerTemplate.sendBody(String.valueOf(this.componentScheme) + ":queue:ignored?destinationResolver=#customDestinationResolver", (Object)message);
        return (String)this.consumerTemplate.receiveBody(String.valueOf(this.componentScheme) + ":queue:testJmsDestinationResolver", 5000L, String.class);
    }

    @Path(value="/{queueName}/custom/message/converter")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String customMessageConverter(@PathParam(value="queueName") String queueName, String message) {
        this.producerTemplate.sendBody(String.valueOf(this.componentScheme) + ":queue:" + queueName + "?messageConverter=#customMessageConverter", (Object)message);
        return (String)this.consumerTemplate.receiveBody(String.valueOf(this.componentScheme) + ":queue:" + queueName + "?messageConverter=#customMessageConverter", 5000L, String.class);
    }

    @Path(value="/{queueName}/transfer/exchange")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @POST
    public Response testTransferExchange(@PathParam(value="queueName") String queueName, String message) throws InterruptedException {
        MockEndpoint mockEndpoint = (MockEndpoint)this.context.getEndpoint("mock:transferExchangeResult", MockEndpoint.class);
        mockEndpoint.expectedMessageCount(1);
        this.producerTemplate.sendBody(String.valueOf(this.componentScheme) + ":queue:" + queueName + "?transferExchange=true", (Object)message);
        mockEndpoint.assertIsSatisfied();
        List exchanges = mockEndpoint.getExchanges();
        Exchange exchange = (Exchange)exchanges.get(0);
        String result = (String)exchange.getMessage().getBody(String.class);
        return Response.ok().entity((Object)result).build();
    }

    @Path(value="/{queueName}/transfer/exception")
    @Produces(value={"text/plain"})
    @GET
    public Response testTransferException(@PathParam(value="queueName") String queueName) {
        try {
            this.producerTemplate.requestBody(String.valueOf(this.componentScheme) + ":queue:" + queueName + "?transferException=true", (Object)"bad payload");
        }
        catch (RuntimeCamelException e) {
            Class<?> exception = e.getCause().getClass();
            return Response.ok().entity((Object)exception.getName()).build();
        }
        return Response.serverError().build();
    }

    @Path(value="/custom/destination/{destinationName}")
    @POST
    public Response produceMessageWithCustomDestination(@QueryParam(value="isStringDestination") boolean isStringDestination, @PathParam(value="destinationName") String destinationName, String message) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (isStringDestination) {
            headers.put("DestinationHeaderType", String.class.getName());
        } else {
            headers.put("DestinationHeaderType", Destination.class.getName());
        }
        headers.put("DestinationName", destinationName);
        this.producerTemplate.sendBodyAndHeaders("direct:computedDestination", (Object)message, headers);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }
}

