/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.messaging.jms;

import io.quarkus.runtime.annotations.RegisterForReflection;
import jakarta.inject.Named;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.UserTransaction;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.jms.MessageListenerContainerFactory;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;

public class JmsProducers {
    @Named
    public MessageListenerContainerFactory customMessageListener() {
        return jmsEndpoint -> new DefaultMessageListenerContainer();
    }

    @Named
    public DestinationResolver customDestinationResolver() {
        return (session, destinationName, pubSubDomain) -> {
            if (destinationName.equals("ignored")) {
                return session.createQueue("testJmsDestinationResolver");
            }
            if (pubSubDomain) {
                return session.createTopic(destinationName);
            }
            return session.createQueue(destinationName);
        };
    }

    @Named
    public PlatformTransactionManager transactionManager(UserTransaction userTransaction, TransactionManager transactionManager) {
        return new JtaTransactionManager(userTransaction, transactionManager);
    }

    @Named
    public MessageConverter customMessageConverter() {
        return new MessageConverter(){

            public jakarta.jms.Message toMessage(Object o, Session session) throws JMSException, MessageConversionException {
                if (o instanceof String) {
                    TextMessage message = session.createTextMessage("converter prefix " + o);
                    return message;
                }
                return null;
            }

            public Object fromMessage(jakarta.jms.Message message) throws JMSException, MessageConversionException {
                if (message instanceof TextMessage) {
                    TextMessage textMessage = (TextMessage)message;
                    return textMessage.getText() + " converter suffix";
                }
                return null;
            }
        };
    }

    @Named
    public DestinationHeaderSetter destinationHeaderSetter() {
        return new DestinationHeaderSetter();
    }

    @RegisterForReflection(fields=false)
    static final class DestinationHeaderSetter {
        DestinationHeaderSetter() {
        }

        public void setJmsDestinationHeader(Exchange exchange) {
            Message message = exchange.getMessage();
            String destinationHeaderType = (String)message.getHeader("DestinationHeaderType", String.class);
            String destinationName = (String)message.getHeader("DestinationName", String.class);
            if (destinationHeaderType.equals(String.class.getName())) {
                message.setHeader("CamelJmsDestinationName", (Object)destinationName);
            } else {
                CamelContext camelContext = exchange.getContext();
                Set factories = camelContext.getRegistry().findByType(ConnectionFactory.class);
                ConnectionFactory connectionFactory = (ConnectionFactory)factories.iterator().next();
                Connection connection = null;
                try {
                    connection = connectionFactory.createConnection();
                    Session session = connection.createSession(false, 1);
                    Queue destination = session.createQueue(destinationName);
                    message.setHeader("CamelJmsDestination", (Object)destination);
                }
                catch (JMSException e) {
                    throw new IllegalStateException("Failed to create JMS connection", e);
                }
                finally {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (JMSException jMSException) {}
                    }
                }
            }
        }
    }
}

