/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.messaging.jms;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.UUID;
import org.apache.camel.quarkus.component.messaging.it.AbstractMessagingTest;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AbstractJmsMessagingTest
extends AbstractMessagingTest {
    @Test
    public void testJmsTransferExchange() {
        String message = "Test transfer message";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(message).post("/messaging/jms/transfer/exchange", new Object[0])).then()).statusCode(200)).body(Is.is((Object)message), new Matcher[0]);
    }

    @Test
    public void testJmsTransferException() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/messaging/jms/transfer/exception", new Object[0])).then()).statusCode(200)).body(Is.is((Object)"java.lang.IllegalStateException"), new Matcher[0]);
    }

    @Test
    public void testJmsMessageListenerContainerFactory() {
        String message = "Camel JMS With Custom MessageListenerContainerFactory";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(message).post("/messaging/jms/custom/message/listener/factory", new Object[0])).then()).statusCode(200)).body(Is.is((Object)message), new Matcher[0]);
    }

    @Test
    public void testJmsDestinationResolver() {
        String message = "Camel JMS With Custom DestinationResolver";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(message).post("/messaging/jms/custom/destination/resolver", new Object[0])).then()).statusCode(200)).body(Is.is((Object)message), new Matcher[0]);
    }

    @Test
    public void testJmsMessageConverter() {
        String result = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("a test message").post("/messaging/jms/custom/message/converter", new Object[0])).then()).statusCode(200)).extract().body().asString();
        Assertions.assertTrue((boolean)result.startsWith("converter prefix"));
        Assertions.assertTrue((boolean)result.endsWith("converter suffix"));
    }

    @Test
    public void testJmsCustomDestination() {
        String message = UUID.randomUUID().toString();
        String destinationA = "queue-" + UUID.randomUUID().toString().split("-")[0];
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("isStringDestination", new Object[]{"true"}).body(message).post("/messaging/jms/custom/destination/{destinationName}", new Object[]{destinationA})).then()).statusCode(201);
        String destinationB = "queue-" + UUID.randomUUID().toString().split("-")[0];
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("isStringDestination", new Object[]{"false"}).body(message).post("/messaging/jms/custom/destination/{destinationName}", new Object[]{destinationB})).then()).statusCode(201);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).get("/messaging/{destinationName}", new Object[]{destinationA})).then()).statusCode(200)).body(Is.is((Object)message), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).get("/messaging/{destinationName}", new Object[]{destinationB})).then()).statusCode(200)).body(Is.is((Object)message), new Matcher[0]);
    }
}

