/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.master.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.camel.quarkus.test.support.process.QuarkusProcessExecutor;
import org.apache.commons.io.FileUtils;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.zeroturnaround.exec.StartedProcess;

@QuarkusTest
class MasterFileTest {
    MasterFileTest() {
    }

    @BeforeAll
    public static void deleteClusterFiles() throws IOException {
        FileUtils.deleteDirectory((File)Paths.get("target/cluster/", new String[0]).toFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailover() throws IOException {
        ArrayList<String> jvmArgs = new ArrayList<String>();
        jvmArgs.add("-Dapplication.id=follower");
        QuarkusProcessExecutor quarkusProcessExecutor = new QuarkusProcessExecutor((String[])jvmArgs.toArray(String[]::new));
        StartedProcess process = quarkusProcessExecutor.start();
        this.awaitStartup(quarkusProcessExecutor);
        try {
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).with().until(() -> this.readLeaderFile("leader").equals("leader"));
            MatcherAssert.assertThat((Object)this.readLeaderFile("follower"), (Matcher)Matchers.emptyString());
            ((ValidatableResponse)((Response)RestAssured.given().get("/master/camel/stop/leader", new Object[0])).then()).statusCode(204);
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> this.readLeaderFile("follower").equals("leader"));
        }
        finally {
            if (process != null && process.getProcess().isAlive()) {
                process.getProcess().destroy();
            }
        }
    }

    private void awaitStartup(QuarkusProcessExecutor quarkusProcessExecutor) {
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).pollDelay(1L, TimeUnit.SECONDS).until(() -> this.isApplicationHealthy(quarkusProcessExecutor.getHttpPort()));
    }

    private boolean isApplicationHealthy(int port) {
        try {
            int status = ((ValidatableResponse)((Response)RestAssured.given().port(port).get("/q/health", new Object[0])).then()).extract().statusCode();
            return status == 200;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String readLeaderFile(String fileName) throws IOException {
        Path path = Paths.get(String.format("target/cluster/%s.txt", fileName), new String[0]);
        if (path.toFile().exists()) {
            return FileUtils.readFileToString((File)path.toFile(), (Charset)StandardCharsets.UTF_8);
        }
        return "";
    }
}

