/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.mapstruct.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Objects;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mapstruct.MapStructMapperFinder;
import org.apache.camel.component.mapstruct.MapstructComponent;
import org.apache.camel.quarkus.component.mapstruct.it.model.ModelFactory;
import org.apache.camel.util.StringHelper;
import org.jboss.logging.Logger;

@Path(value="/mapstruct")
@ApplicationScoped
public class MapStructResource {
    private static final Logger LOG = Logger.getLogger(MapStructResource.class);
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    CamelContext context;

    @Path(value="/component")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response componentTest(@QueryParam(value="fromTypeName") String fromTypeName, @QueryParam(value="toTypeName") String toTypeName, String pojoString) {
        try {
            String result = this.doMapping(fromTypeName, toTypeName, "component", pojoString);
            return Response.ok((Object)result).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error occurred during mapping", (Throwable)e);
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            return Response.serverError().entity((Object)message).build();
        }
    }

    @Path(value="/converter")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response converterTest(@QueryParam(value="fromTypeName") String fromTypeName, @QueryParam(value="toTypeName") String toTypeName, String pojoString) {
        try {
            String result = this.doMapping(fromTypeName, toTypeName, "converter", pojoString);
            return Response.ok((Object)result).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error occurred during mapping", (Throwable)e);
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            return Response.serverError().entity((Object)message).build();
        }
    }

    @Path(value="/finder/mapper")
    @GET
    @Produces(value={"text/plain"})
    public String mapStructMapperFinderImpl() {
        MapstructComponent component = (MapstructComponent)this.context.getComponent("mapstruct", MapstructComponent.class);
        MapStructMapperFinder mapStructConverter = component.getMapStructConverter();
        Objects.requireNonNull(mapStructConverter, "mapStructConverter should not be null");
        return mapStructConverter.getClass().getName();
    }

    @Path(value="/component/packages")
    @GET
    @Produces(value={"text/plain"})
    public String mapStructComponentPackages() {
        MapstructComponent component = (MapstructComponent)this.context.getComponent("mapstruct", MapstructComponent.class);
        return component.getMapperPackageName();
    }

    private String doMapping(String fromType, String toType, String endpoint, String pojoString) {
        Object pojo = ModelFactory.getModel(pojoString, fromType);
        String toTypeHeader = endpoint.equals("component") ? toType : StringHelper.afterLast((String)toType.toLowerCase(), (String)".");
        return this.producerTemplate.requestBodyAndHeader("direct:" + endpoint, pojo, "toType", (Object)toTypeHeader).toString();
    }
}

