/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.mapstruct.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.camel.quarkus.component.mapstruct.CamelQuarkusMapStructMapperFinder;
import org.apache.camel.quarkus.component.mapstruct.it.mapper.car.CarMapper;
import org.apache.camel.quarkus.component.mapstruct.it.mapper.cat.CatMapper;
import org.apache.camel.quarkus.component.mapstruct.it.mapper.dog.DogMapper;
import org.apache.camel.quarkus.component.mapstruct.it.mapper.employee.EmployeeMapper;
import org.apache.camel.quarkus.component.mapstruct.it.mapper.vehicle.VehicleMapper;
import org.apache.camel.quarkus.component.mapstruct.it.model.Bike;
import org.apache.camel.quarkus.component.mapstruct.it.model.Car;
import org.apache.camel.quarkus.component.mapstruct.it.model.Cat;
import org.apache.camel.quarkus.component.mapstruct.it.model.Dog;
import org.apache.camel.quarkus.component.mapstruct.it.model.Employee;
import org.apache.camel.quarkus.component.mapstruct.it.model.EmployeeDto;
import org.apache.camel.quarkus.component.mapstruct.it.model.Vehicle;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@QuarkusTest
public class MapStructTest {
    @ParameterizedTest
    @ValueSource(strings={"component", "converter"})
    void mapVehicleToCar(String value) {
        Vehicle vehicle = new Vehicle("Volvo", "XC60", "true", 2021);
        String response = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("fromTypeName", new Object[]{Vehicle.class.getName()}).queryParam("toTypeName", new Object[]{Car.class.getName()}).body(vehicle.toString()).post("/mapstruct/" + value, new Object[0])).then()).statusCode(200)).extract().body().asString();
        Car car = Car.fromString((String)response);
        Assertions.assertEquals((Object)vehicle.getCompany(), (Object)car.getBrand());
        Assertions.assertEquals((Object)vehicle.getName(), (Object)car.getModel());
        Assertions.assertEquals((int)vehicle.getYear(), (int)car.getYear());
        Assertions.assertEquals((Object)Boolean.parseBoolean(vehicle.getPower()), (Object)car.isElectric());
    }

    @ParameterizedTest
    @ValueSource(strings={"component", "converter"})
    void mapBikeToCar(String value) {
        Bike bike = new Bike("Honda", "CBR65R", 2023, false);
        String response = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("fromTypeName", new Object[]{Bike.class.getName()}).queryParam("toTypeName", new Object[]{Car.class.getName()}).body(bike.toString()).post("/mapstruct/" + value, new Object[0])).then()).statusCode(200)).extract().body().asString();
        Car car = Car.fromString((String)response);
        Assertions.assertEquals((Object)bike.getMake(), (Object)car.getBrand());
        Assertions.assertEquals((Object)bike.getModelNumber(), (Object)car.getModel());
        Assertions.assertEquals((int)bike.getYear(), (int)car.getYear());
        Assertions.assertEquals((Object)bike.isElectric(), (Object)car.isElectric());
    }

    @ParameterizedTest
    @ValueSource(strings={"component", "converter"})
    void mapDogToCatWithAlternatePackageAndClassName(String value) {
        Dog dog = new Dog("1", "Snoopy", 8, "bark");
        String response = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("fromTypeName", new Object[]{Dog.class.getName()}).queryParam("toTypeName", new Object[]{Cat.class.getName()}).body(dog.toString()).post("/mapstruct/" + value, new Object[0])).then()).statusCode(200)).extract().body().asString();
        Cat cat = Cat.fromString((String)response);
        Assertions.assertEquals((Object)dog.getDogId(), (Object)cat.getCatId());
        Assertions.assertEquals((Object)dog.getName(), (Object)cat.getName());
        Assertions.assertEquals((int)dog.getAge(), (int)cat.getAge());
        Assertions.assertEquals((Object)"meow", (Object)cat.getSound());
    }

    @ParameterizedTest
    @ValueSource(strings={"component", "converter"})
    void mapCatToDogWithApplicationScopedMapperBean(String value) {
        Cat cat = new Cat("1", "Garfield", 12, "meow");
        String response = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("fromTypeName", new Object[]{Cat.class.getName()}).queryParam("toTypeName", new Object[]{Dog.class.getName()}).body(cat.toString()).post("/mapstruct/" + value, new Object[0])).then()).statusCode(200)).extract().body().asString();
        Dog dog = Dog.fromString((String)response);
        Assertions.assertEquals((Object)cat.getCatId(), (Object)dog.getDogId());
        Assertions.assertEquals((Object)cat.getName(), (Object)dog.getName());
        Assertions.assertEquals((int)cat.getAge(), (int)dog.getAge());
        Assertions.assertEquals((Object)"bark", (Object)dog.getVocalization());
    }

    @ParameterizedTest
    @ValueSource(strings={"component", "converter"})
    void mapEmployeeToEmployeeDtoWithAlternateClassName(String value) {
        Employee employee = new Employee();
        employee.setId(1);
        employee.setName("Mr Camel Quarkus");
        String response = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("fromTypeName", new Object[]{Employee.class.getName()}).queryParam("toTypeName", new Object[]{EmployeeDto.class.getName()}).body(employee.toString()).post("/mapstruct/" + value, new Object[0])).then()).statusCode(200)).extract().body().asString();
        EmployeeDto dto = EmployeeDto.fromString((String)response);
        Assertions.assertEquals((int)employee.getId(), (int)dto.getEmployeeId());
        Assertions.assertEquals((Object)employee.getName(), (Object)dto.getEmployeeName());
    }

    @ParameterizedTest
    @ValueSource(strings={"component", "converter"})
    void mapEmployeeDtoToEmployeeWithInheritedMapperMethod(String value) {
        EmployeeDto dto = new EmployeeDto();
        dto.setEmployeeId(1);
        dto.setEmployeeName("Mr Camel Quarkus");
        String response = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("fromTypeName", new Object[]{EmployeeDto.class.getName()}).queryParam("toTypeName", new Object[]{Employee.class.getName()}).body(dto.toString()).post("/mapstruct/" + value, new Object[0])).then()).statusCode(200)).extract().body().asString();
        Employee employee = Employee.fromString((String)response);
        Assertions.assertEquals((int)dto.getEmployeeId(), (int)employee.getId());
        Assertions.assertEquals((Object)dto.getEmployeeName(), (Object)employee.getName());
    }

    @ParameterizedTest
    @ValueSource(strings={"component", "converter"})
    void mapCarToVehicleUsingStaticFieldMapper(String value) {
        Car car = new Car("Volvo", "XC60", 2021, true);
        String response = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("fromTypeName", new Object[]{Car.class.getName()}).queryParam("toTypeName", new Object[]{Vehicle.class.getName()}).body(car.toString()).post("/mapstruct/" + value, new Object[0])).then()).statusCode(200)).extract().body().asString();
        Vehicle vehicle = Vehicle.fromString((String)response);
        Assertions.assertEquals((Object)car.getBrand(), (Object)vehicle.getCompany());
        Assertions.assertEquals((Object)car.getModel(), (Object)vehicle.getName());
        Assertions.assertEquals((int)car.getYear(), (int)vehicle.getYear());
        Assertions.assertEquals((Object)car.isElectric(), (Object)Boolean.parseBoolean(vehicle.getPower()));
    }

    @Test
    void mapStructMapperFinderImpl() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/mapstruct/finder/mapper", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)CamelQuarkusMapStructMapperFinder.class.getName()), new Matcher[0]);
    }

    @Test
    void mapStructComponentPackages() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/mapstruct/component/packages", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.containsString((String)CarMapper.class.getPackageName()), new Matcher[]{Matchers.containsString((String)CatMapper.class.getPackageName()), Matchers.containsString((String)DogMapper.class.getPackageName()), Matchers.containsString((String)EmployeeMapper.class.getPackageName()), Matchers.containsString((String)VehicleMapper.class.getPackageName())});
    }
}

