/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.mapstruct.it;

import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.camel.quarkus.component.mapstruct.it.MapStructExplicitPackagesTestProfile;
import org.apache.camel.quarkus.component.mapstruct.it.mapper.car.CarMapper;
import org.apache.camel.quarkus.component.mapstruct.it.mapper.vehicle.VehicleMapper;
import org.apache.camel.quarkus.component.mapstruct.it.model.Car;
import org.apache.camel.quarkus.component.mapstruct.it.model.Employee;
import org.apache.camel.quarkus.component.mapstruct.it.model.EmployeeDto;
import org.apache.camel.quarkus.component.mapstruct.it.model.Vehicle;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@QuarkusTest
@TestProfile(value=MapStructExplicitPackagesTestProfile.class)
public class MapStructExplicitPackagesTest {
    @ParameterizedTest
    @ValueSource(strings={"component", "converter"})
    void mapVehicleToCarSuccess(String value) {
        Vehicle vehicle = new Vehicle("Volvo", "XC60", "true", 2021);
        String response = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("fromTypeName", new Object[]{Vehicle.class.getName()}).queryParam("toTypeName", new Object[]{Car.class.getName()}).body(vehicle.toString()).post("/mapstruct/" + value, new Object[0])).then()).statusCode(200)).extract().body().asString();
        Car car = Car.fromString((String)response);
        Assertions.assertEquals((Object)vehicle.getCompany(), (Object)car.getBrand());
        Assertions.assertEquals((Object)vehicle.getName(), (Object)car.getModel());
        Assertions.assertEquals((int)vehicle.getYear(), (int)car.getYear());
        Assertions.assertEquals((Object)Boolean.parseBoolean(vehicle.getPower()), (Object)car.isElectric());
    }

    @ParameterizedTest
    @ValueSource(strings={"component", "converter"})
    void mapEmployeeToEmployeeDtoFail(String value) {
        Employee employee = new Employee();
        employee.setId(1);
        employee.setName("Mr Camel Quarkus");
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("fromTypeName", new Object[]{Employee.class.getName()}).queryParam("toTypeName", new Object[]{EmployeeDto.class.getName()}).body(employee.toString()).post("/mapstruct/" + value, new Object[0])).then()).statusCode(500)).body(Matchers.containsString((String)"NoTypeConversionAvailableException"), new Matcher[0]);
    }

    @Test
    void mapStructComponentPackages() {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/mapstruct/component/packages", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.containsString((String)CarMapper.class.getPackageName()), new Matcher[]{Matchers.containsString((String)VehicleMapper.class.getPackageName())});
    }
}

