/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.management.it;

import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.lang.management.ManagementFactory;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;

@Path(value="/management")
public class ManagementResource {
    @Inject
    ProducerTemplate template;
    @Inject
    CamelContext camelContext;

    @GET
    @Path(value="/context/name")
    @Produces(value={"text/plain"})
    public String getContextName() {
        return this.camelContext.getName();
    }

    @GET
    @Path(value="/attribute")
    @Produces(value={"text/plain"})
    public String getMBeanAttribute(@QueryParam(value="name") String name, @QueryParam(value="attribute") String attribute) throws Exception {
        ObjectInstance mbean = this.getMBean(name);
        if (mbean != null) {
            return String.valueOf(this.getMBeanServer().getAttribute(mbean.getObjectName(), attribute));
        }
        return null;
    }

    @POST
    @Path(value="/invoke")
    @Produces(value={"text/plain"})
    public String invokeMBeanOperation(@QueryParam(value="name") String name, @QueryParam(value="operation") String operation) throws Exception {
        ObjectInstance mbean = this.getMBean(name);
        if (mbean != null) {
            return String.valueOf(this.getMBeanServer().invoke(mbean.getObjectName(), operation, new Object[0], new String[0]));
        }
        return null;
    }

    @POST
    @Path(value="/invoke/route")
    public String invokeRoute(@QueryParam(value="endpointUri") String endpointUri) {
        return (String)this.template.requestBody(endpointUri, null, String.class);
    }

    private ObjectInstance getMBean(String name) throws MalformedObjectNameException {
        ObjectName objectName = new ObjectName(name);
        Set<ObjectInstance> mbeans = this.getMBeanServer().queryMBeans(objectName, null);
        Iterator<ObjectInstance> iterator = mbeans.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    private MBeanServer getMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }
}

