/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.management.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@QuarkusTest
class ManagementTest {
    ManagementTest() {
    }

    @ParameterizedTest
    @ValueSource(strings={"components", "consumers", "context", "dataformats", "endpoints", "processors", "routes", "services"})
    public void testManagementObjects(String type) {
        String contextName = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/management/context/name", (Object[])new Object[0]).then()).statusCode(200)).extract().body().asString();
        String name = "org.apache.camel:type=" + type + ",*";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("name", new Object[]{name}).queryParam("attribute", new Object[]{"CamelId"}).get("/management/attribute", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)contextName), new Matcher[0]);
    }

    @Test
    public void testDumpRoutesAsXml() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("name", new Object[]{"org.apache.camel:type=context,*"}).queryParam("operation", new Object[]{"dumpRoutesAsXml"}).post("/management/invoke", new Object[0])).then()).statusCode(200)).body(Matchers.containsString((String)"uri=\"direct:start\""), new Matcher[0]);
    }

    @Test
    public void testUpdateRoute() {
        String updatedRouteXml = "    <route id=\"hello\" xmlns=\"http://camel.apache.org/schema/spring\">\n        <from uri=\"direct:updated\"/>\n        <log message=\"Updated hello route\"/>\n    </route>\n";
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("routeId", new Object[]{"hello"}).body(updatedRouteXml).patch("/management/route", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("name", new Object[]{"org.apache.camel:type=context,*"}).queryParam("operation", new Object[]{"dumpRoutesAsXml"}).post("/management/invoke", new Object[0])).then()).statusCode(200)).body(Matchers.containsString((String)"uri=\"direct:updated\""), new Matcher[0]);
        String originalRouteXml = "    <route id=\"hello\" xmlns=\"http://camel.apache.org/schema/spring\">\n        <from uri=\"direct:start\"/>\n        <setBody>\n            <constant>Hello World</constant>\n        </setBody>\n    </route>\n";
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("routeId", new Object[]{"hello"}).body(originalRouteXml).patch("/management/route", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("name", new Object[]{"org.apache.camel:type=context,*"}).queryParam("operation", new Object[]{"dumpRoutesAsXml"}).post("/management/invoke", new Object[0])).then()).statusCode(200)).body(Matchers.containsString((String)"uri=\"direct:start\""), new Matcher[0]);
    }

    @Test
    public void testManagedBean() {
        String name = "org.apache.camel:type=processors,name=\"counter\",*";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("name", new Object[]{name}).queryParam("attribute", new Object[]{"Count"}).get("/management/attribute", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"0"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("name", new Object[]{name}).queryParam("operation", new Object[]{"increment"}).post("/management/invoke", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("name", new Object[]{name}).queryParam("attribute", new Object[]{"Count"}).get("/management/attribute", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"1"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("endpointUri", new Object[]{"direct:count"}).post("/management/invoke/route", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("name", new Object[]{name}).queryParam("attribute", new Object[]{"Count"}).get("/management/attribute", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"2"), new Matcher[0]);
    }
}

