/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.management.it;

import io.quarkus.test.junit.QuarkusTest;
import jakarta.inject.Inject;
import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@QuarkusTest
class ManagementTest {
    private MBeanServer server;
    @Inject
    ProducerTemplate template;
    @Inject
    CamelContext camelContext;

    ManagementTest() {
    }

    @BeforeEach
    public void setUp() {
        this.server = ManagementFactory.getPlatformMBeanServer();
    }

    @ParameterizedTest
    @ValueSource(strings={"components", "consumers", "context", "dataformats", "endpoints", "processors", "routes", "services"})
    public void testManagementObjects(String type) throws Exception {
        ObjectName objectName = new ObjectName("org.apache.camel:type=" + type + ",*");
        Set<ObjectInstance> mbeans = this.server.queryMBeans(objectName, null);
        Assertions.assertTrue((mbeans.size() > 0 ? 1 : 0) != 0);
        ObjectInstance mbean = mbeans.iterator().next();
        String camelId = (String)this.server.getAttribute(mbean.getObjectName(), "CamelId");
        Assertions.assertEquals((Object)this.camelContext.getName(), (Object)camelId);
    }

    @Test
    public void testDumpRoutesAsXml() throws Exception {
        ObjectName objectName = new ObjectName("org.apache.camel:type=context,*");
        Set<ObjectInstance> mbeans = this.server.queryMBeans(objectName, null);
        Assertions.assertEquals((int)1, (int)mbeans.size());
        ObjectInstance instance = mbeans.iterator().next();
        String routeXML = (String)this.server.invoke(instance.getObjectName(), "dumpRoutesAsXml", new Object[0], new String[0]);
        Assertions.assertTrue((boolean)routeXML.contains("<from uri=\"direct:start\"/>"));
    }

    @Test
    public void testManagedBean() throws Exception {
        ObjectName objectName = new ObjectName("org.apache.camel:type=processors,name=\"counter\",*");
        Set<ObjectInstance> mbeans = this.server.queryMBeans(objectName, null);
        Assertions.assertEquals((int)1, (int)mbeans.size());
        ObjectInstance instance = mbeans.iterator().next();
        Integer count = (Integer)this.server.getAttribute(instance.getObjectName(), "Count");
        Assertions.assertEquals((int)0, (Integer)count);
        this.server.invoke(instance.getObjectName(), "increment", new Object[0], new String[0]);
        count = (Integer)this.server.getAttribute(instance.getObjectName(), "Count");
        Assertions.assertEquals((int)1, (Integer)count);
        this.template.requestBody("direct:count", (Object)"");
        count = (Integer)this.server.getAttribute(instance.getObjectName(), "Count");
        Assertions.assertEquals((int)2, (Integer)count);
    }
}

