/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.main;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Objects;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ServiceStatus;
import org.apache.camel.component.log.LogComponent;
import org.apache.camel.impl.debugger.DebuggerJmxConnectorService;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.quarkus.core.FastFactoryFinderResolver;
import org.apache.camel.quarkus.it.support.typeconverter.MyPair;
import org.apache.camel.quarkus.main.CamelMain;
import org.apache.camel.quarkus.main.CamelMainRoutesCollector;
import org.apache.camel.quarkus.main.ContextReloadObserver;
import org.apache.camel.reactive.vertx.VertXReactiveExecutor;
import org.apache.camel.reactive.vertx.VertXThreadPoolFactory;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.spi.ContextReloadStrategy;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.ThreadPoolFactory;
import org.apache.camel.support.DefaultRegistry;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.processor.DefaultExchangeFormatter;

@Path(value="/test")
@ApplicationScoped
public class CoreMainResource {
    @Inject
    CamelMain main;

    @Path(value="/property/{name}")
    @GET
    @Produces(value={"text/plain"})
    public String getProperty(@PathParam(value="name") String name) throws Exception {
        return this.main.getCamelContext().resolvePropertyPlaceholders("{{" + name + "}}");
    }

    @Path(value="/registry/log/exchange-formatter")
    @GET
    @Produces(value={"application/json"})
    public JsonObject exchangeFormatterConfig() {
        LogComponent component = (LogComponent)this.main.getCamelContext().getRegistry().lookupByNameAndType("log", LogComponent.class);
        DefaultExchangeFormatter def = (DefaultExchangeFormatter)component.getExchangeFormatter();
        JsonObject result = Json.createObjectBuilder().add("show-all", def.isShowAll()).add("multi-line", def.isMultiline()).build();
        return result;
    }

    @Path(value="/context/name")
    @GET
    @Produces(value={"text/plain"})
    public String getCamelContextName() {
        return this.main.getCamelContext().getName();
    }

    @Path(value="/context/name")
    @POST
    @Produces(value={"text/plain"})
    public String setCamelContextName(String name) {
        this.main.getCamelContext().getCamelContextExtension().setName(name);
        return this.main.getCamelContext().getName();
    }

    @Path(value="/main/describe")
    @GET
    @Produces(value={"application/json"})
    public JsonObject describeMain() {
        CamelContext camelContext = this.main.getCamelContext();
        JsonArrayBuilder listeners = Json.createArrayBuilder();
        this.main.getMainListeners().forEach(listener -> listeners.add(listener.getClass().getName()));
        JsonArrayBuilder routeBuilders = Json.createArrayBuilder();
        this.main.configure().getRoutesBuilders().forEach(builder -> routeBuilders.add(builder.getClass().getName()));
        JsonArrayBuilder routes = Json.createArrayBuilder();
        camelContext.getRoutes().forEach(route -> routes.add(route.getId()));
        JsonObjectBuilder collector = Json.createObjectBuilder();
        collector.add("type", this.main.getRoutesCollector().getClass().getName());
        if (this.main.getRoutesCollector() instanceof CamelMainRoutesCollector) {
            CamelMainRoutesCollector crc = (CamelMainRoutesCollector)this.main.getRoutesCollector();
            collector.add("type-registry", crc.getRegistryRoutesLoader().getClass().getName());
        }
        JsonObjectBuilder dataformatsInRegistry = Json.createObjectBuilder();
        camelContext.getRegistry().findByTypeWithName(DataFormat.class).forEach((name, value) -> dataformatsInRegistry.add(name, value.getClass().getName()));
        JsonObjectBuilder languagesInRegistry = Json.createObjectBuilder();
        camelContext.getRegistry().findByTypeWithName(Language.class).forEach((name, value) -> languagesInRegistry.add(name, value.getClass().getName()));
        JsonObjectBuilder componentsInRegistry = Json.createObjectBuilder();
        camelContext.getRegistry().findByTypeWithName(Component.class).forEach((name, value) -> componentsInRegistry.add(name, value.getClass().getName()));
        JsonObjectBuilder factoryClassMap = Json.createObjectBuilder();
        FactoryFinderResolver factoryFinderResolver = PluginHelper.getFactoryFinderResolver((CamelContext)camelContext);
        if (factoryFinderResolver instanceof FastFactoryFinderResolver) {
            ((FastFactoryFinderResolver)factoryFinderResolver).getClassMap().forEach((k, v) -> factoryClassMap.add(k, v.getName()));
        }
        return Json.createObjectBuilder().add("xml-model-dumper", PluginHelper.getModelToXMLDumper((CamelContext)camelContext).getClass().getName()).add("routes-collector", collector).add("listeners", listeners).add("routeBuilders", routeBuilders).add("routes", routes).add("lru-cache-factory", LRUCacheFactory.getInstance().getClass().getName()).add("autoConfigurationLogSummary", this.main.getMainConfigurationProperties().isAutoConfigurationLogSummary()).add("config", Json.createObjectBuilder().add("rest-port", camelContext.getRestConfiguration().getPort()).add("resilience4j-sliding-window-size", ((ModelCamelContext)camelContext).getResilience4jConfiguration(null).getSlidingWindowSize())).add("registry", Json.createObjectBuilder().add("components", componentsInRegistry).add("dataformats", dataformatsInRegistry).add("languages", languagesInRegistry)).add("factory-finder", Json.createObjectBuilder().add("class-map", factoryClassMap)).add("bean-introspection-invocations", PluginHelper.getBeanIntrospection((CamelContext)camelContext).getInvokedCounter()).build();
    }

    @Path(value="/context/reactive-executor")
    @GET
    @Produces(value={"text/plain"})
    public JsonObject reactiveExecutor() {
        ReactiveExecutor executor = this.main.getCamelContext().getCamelContextExtension().getReactiveExecutor();
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("class", executor.getClass().getName());
        if (executor instanceof VertXReactiveExecutor) {
            builder.add("configured", ((VertXReactiveExecutor)executor).getVertx() != null);
        }
        return builder.build();
    }

    @Path(value="/context/thread-pool-factory")
    @GET
    @Produces(value={"text/plain"})
    public JsonObject threadPoolFactory() {
        ThreadPoolFactory threadPoolFactory = this.main.getCamelContext().getExecutorServiceManager().getThreadPoolFactory();
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("class", threadPoolFactory.getClass().getName());
        if (threadPoolFactory instanceof VertXThreadPoolFactory) {
            builder.add("configured", ((VertXThreadPoolFactory)threadPoolFactory).getVertx() != null);
        }
        return builder.build();
    }

    @Path(value="/converter/my-pair")
    @POST
    @Produces(value={"application/json"})
    public JsonObject fromStringToMyPair(String input) {
        MyPair pair = (MyPair)this.main.getCamelContext().getTypeConverter().convertTo(MyPair.class, (Object)input);
        return Json.createObjectBuilder().add("key", pair.key).add("val", pair.val).build();
    }

    @Path(value="/registry/component/{name}")
    @GET
    @Produces(value={"application/json"})
    public JsonObject describeRegistryComponent(@PathParam(value="name") String name) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        DefaultRegistry registry = (DefaultRegistry)this.main.getCamelContext().getRegistry(DefaultRegistry.class);
        JsonObjectBuilder builder = Json.createObjectBuilder();
        Component component = (Component)registry.getFallbackRegistry().lookupByNameAndType(name, Component.class);
        if (component != null) {
            builder.add("type", component.getClass().getName());
            builder.add("registry", "fallback");
            builder.add("registry-type", registry.getFallbackRegistry().getClass().getName());
        } else {
            for (BeanRepository repository : registry.getRepositories()) {
                component = (Component)repository.lookupByNameAndType(name, Component.class);
                if (component == null) continue;
                builder.add("type", component.getClass().getName());
                builder.add("registry", "repository");
                builder.add("registry-type", repository.getClass().getName());
                break;
            }
        }
        if (component != null) {
            PluginHelper.getBeanIntrospection((CamelContext)this.main.getCamelContext()).getProperties((Object)component, properties, null);
            properties.forEach((k, v) -> {
                if (v != null) {
                    builder.add(k, Objects.toString(v));
                }
            });
        }
        return builder.build();
    }

    @Path(value="/registry/string/{name}")
    @GET
    @Produces(value={"text/plain"})
    public String getStringValueFromRegistry(@PathParam(value="name") String name) {
        DefaultRegistry registry = (DefaultRegistry)this.main.getCamelContext().getRegistry(DefaultRegistry.class);
        return (String)registry.getFallbackRegistry().lookupByNameAndType(name, String.class);
    }

    @Path(value="/service/jmx-connector/status")
    @GET
    @Produces(value={"text/plain"})
    public String getJmxConnectorServiceStatus() {
        DebuggerJmxConnectorService service = (DebuggerJmxConnectorService)this.main.getCamelContext().hasService(DebuggerJmxConnectorService.class);
        if (service == null) {
            return ServiceStatus.Stopped.name().toUpperCase();
        }
        return service.getStatus().name().toUpperCase();
    }

    @Path(value="/service/jmx-connector/expected/connect/state")
    @GET
    @Produces(value={"text/plain"})
    public boolean jmxConnectorServiceAvailabilityIsExpectedState() {
        boolean bl;
        boolean isNativeMode = "executable".equals(System.getProperty("org.graalvm.nativeimage.kind"));
        Socket socket = new Socket("localhost", 1099);
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return isNativeMode && e instanceof ConnectException;
            }
        }
        socket.close();
        return bl;
    }

    @Path(value="/context/reload/strategy")
    @GET
    @Produces(value={"text/plain"})
    public String contextReloadStrategy() {
        ContextReloadStrategy contextReloadStrategy = (ContextReloadStrategy)this.main.getCamelContext().hasService(ContextReloadStrategy.class);
        if (contextReloadStrategy != null) {
            return contextReloadStrategy.getClass().getName();
        }
        return null;
    }

    @Path(value="/context/reload")
    @GET
    @Produces(value={"text/plain"})
    public boolean contextReloadStatus() {
        return ContextReloadObserver.contextReloaded.get();
    }

    @Path(value="/context/reload")
    @POST
    public void contextReload() {
        ContextReloadStrategy contextReloadStrategy = (ContextReloadStrategy)this.main.getCamelContext().hasService(ContextReloadStrategy.class);
        if (contextReloadStrategy != null) {
            contextReloadStrategy.onReload((Object)this);
        }
    }
}

