/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.main;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import java.util.Map;
import org.apache.camel.quarkus.core.DisabledModelToXMLDumper;
import org.apache.camel.quarkus.core.DisabledXMLRoutesDefinitionLoader;
import org.apache.camel.quarkus.core.RegistryRoutesLoaders;
import org.apache.camel.quarkus.it.support.mainlistener.CustomMainListener;
import org.apache.camel.quarkus.main.CamelMainEventBridge;
import org.apache.camel.quarkus.main.CamelMainRoutesCollector;
import org.apache.camel.quarkus.main.CamelRoute;
import org.apache.camel.quarkus.main.CamelRouteFiltered;
import org.apache.camel.quarkus.test.Conditions;
import org.apache.camel.reactive.vertx.VertXReactiveExecutor;
import org.apache.camel.reactive.vertx.VertXThreadPoolFactory;
import org.apache.camel.support.DefaultLRUCacheFactory;
import org.apache.camel.util.CollectionHelper;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class CoreMainTest {
    @Disabled
    @Test
    public void testProperties() {
        ((ValidatableResponse)((Response)RestAssured.when().get("/test/property/camel.context.name", new Object[0])).then()).body(Matchers.is((Object)"quarkus-camel-example"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.when().get("/test/property/the.message", new Object[0])).then()).body(Matchers.is((Object)"test"), new Matcher[0]);
    }

    @Test
    public void testSetCamelContextName() {
        Response response = (Response)RestAssured.get((String)"/test/context/name", (Object[])new Object[0]).andReturn();
        org.junit.jupiter.api.Assertions.assertEquals((int)200, (int)response.getStatusCode());
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)"my-ctx-name", (Object)response.body().asString());
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("my-ctx-name").post("/test/context/name", new Object[0])).then()).body(Matchers.is((Object)"my-ctx-name"), new Matcher[0]);
    }

    @Test
    public void testMainInstance() {
        JsonPath p = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept("application/json").get("/test/main/describe", new Object[0])).then()).statusCode(200)).extract().body().jsonPath();
        Assertions.assertThat((String)p.getString("xml-loader")).isEqualTo(DisabledXMLRoutesDefinitionLoader.class.getName());
        Assertions.assertThat((String)p.getString("xml-model-dumper")).isEqualTo(DisabledModelToXMLDumper.class.getName());
        Assertions.assertThat((String)p.getString("routes-collector.type")).isEqualTo(CamelMainRoutesCollector.class.getName());
        Assertions.assertThat((String)p.getString("routes-collector.type-registry")).isEqualTo(RegistryRoutesLoaders.Default.class.getName());
        Assertions.assertThat((String)p.getString("routes-collector.type-xml")).isEqualTo(DisabledXMLRoutesDefinitionLoader.class.getName());
        Assertions.assertThat((List)p.getList("listeners", String.class)).containsAnyOf((Object[])new String[]{CamelMainEventBridge.class.getName(), CustomMainListener.class.getName()});
        Assertions.assertThat((List)p.getList("routeBuilders", String.class)).contains((Object[])new String[]{CamelRoute.class.getName()}).doesNotContain((Object[])new String[]{CamelRouteFiltered.class.getName()});
        Assertions.assertThat((List)p.getList("routes", String.class)).contains((Object[])new String[]{"keep-alive", "configure", "beforeStart", "produced", "endpointdsl"}).doesNotContain((Object[])new String[]{"filtered"});
        Assertions.assertThat((String)p.getString("lru-cache-factory")).isEqualTo(DefaultLRUCacheFactory.class.getName());
        Assertions.assertThat((boolean)p.getBoolean("autoConfigurationLogSummary")).isFalse();
        Assertions.assertThat((Map)p.getMap("registry.components", String.class, String.class)).isNotEmpty();
        Assertions.assertThat((Map)p.getMap("registry.dataformats", String.class, String.class)).isEmpty();
        Assertions.assertThat((Map)p.getMap("registry.languages", String.class, String.class)).containsExactlyInAnyOrderEntriesOf(CollectionHelper.mapOf((Object)"constant", (Object)"org.apache.camel.language.constant.ConstantLanguage", (Object[])new Object[]{"file", "org.apache.camel.language.simple.FileLanguage", "header", "org.apache.camel.language.header.HeaderLanguage", "simple", "org.apache.camel.language.simple.SimpleLanguage", "ref", "org.apache.camel.language.ref.RefLanguage"}));
        Map factoryFinderMap = p.getMap("factory-finder.class-map", String.class, String.class);
        ((MapAssert)Assertions.assertThat((Map)factoryFinderMap).hasKeySatisfying(Conditions.startsWith((String)"META-INF/services/org/apache/camel/dataformat/"))).hasEntrySatisfying(Conditions.entry((String)"META-INF/services/org/apache/camel/dataformat/my-dataformat", (String)"org.apache.camel.quarkus.it.support.dataformat.MyDataformat"));
        ((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)factoryFinderMap).hasKeySatisfying(Conditions.startsWith((String)"META-INF/services/org/apache/camel/language/"))).hasKeySatisfying(Conditions.doesNotStartWith((String)"META-INF/services/org/apache/camel/language/constant"))).hasKeySatisfying(Conditions.doesNotStartWith((String)"META-INF/services/org/apache/camel/language/file"))).hasKeySatisfying(Conditions.doesNotStartWith((String)"META-INF/services/org/apache/camel/language/header"))).hasKeySatisfying(Conditions.doesNotStartWith((String)"META-INF/services/org/apache/camel/language/ref"))).hasKeySatisfying(Conditions.doesNotStartWith((String)"META-INF/services/org/apache/camel/language/simple"));
        Assertions.assertThat((Map)factoryFinderMap).hasKeySatisfying(Conditions.doesNotStartWith((String)"META-INF/services/org/apache/camel/component/"));
        Assertions.assertThat((Map)factoryFinderMap).hasKeySatisfying(Conditions.startsWith((String)"META-INF/services/org/apache/camel/configurer/"));
        ((MapAssert)Assertions.assertThat((Map)factoryFinderMap).hasKeySatisfying(Conditions.doesNotStartWith((String)"META-INF/services/org/apache/camel/properties-component-factory"))).hasKeySatisfying(Conditions.doesNotStartWith((String)"META-INF/services/org/apache/camel/reactive-executor"));
        Assertions.assertThat((String)p.getString("config.rest-port")).isEqualTo("9876");
        Assertions.assertThat((String)p.getString("config.resilience4j-sliding-window-size")).isEqualTo("1234");
        Assertions.assertThat((long)p.getLong("bean-introspection-invocations")).isEqualTo(0L);
    }

    @Test
    public void testReactiveExecutor() {
        JsonPath executor = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/test/context/reactive-executor", new Object[0])).then()).statusCode(200)).extract().body().jsonPath();
        Assertions.assertThat((String)executor.getString("class")).isEqualTo(VertXReactiveExecutor.class.getName());
        Assertions.assertThat((boolean)executor.getBoolean("configured")).isTrue();
    }

    @Test
    public void testThreadPoolFactory() {
        JsonPath executor = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/test/context/thread-pool-factory", new Object[0])).then()).statusCode(200)).extract().body().jsonPath();
        Assertions.assertThat((String)executor.getString("class")).isEqualTo(VertXThreadPoolFactory.class.getName());
        Assertions.assertThat((boolean)executor.getBoolean("configured")).isTrue();
    }

    @Test
    public void testCustomTypeConverter() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("a:b").accept("application/json").post("/test/converter/my-pair", new Object[0])).then()).body("key", Matchers.is((Object)"a"), new Object[]{"val", Matchers.is((Object)"b")});
    }

    @Test
    public void testCustomComponent() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept("application/json").get("/test/registry/component/direct", new Object[0])).then()).statusCode(200)).body("timeout", Matchers.is((Object)"1234"), new Object[]{"registry", Matchers.is((Object)"repository"), "registry-type", Matchers.is((Object)"org.apache.camel.quarkus.core.RuntimeBeanRepository")});
    }

    @Test
    public void testGetStringFromRegistry() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept("text/plain").get("/test/registry/string/stringFromRegistry", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"String From Registry"), new Matcher[0]);
    }
}

