/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.main;

import java.util.HashMap;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.camel.Component;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.component.log.LogComponent;
import org.apache.camel.component.timer.TimerComponent;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.quarkus.core.FastFactoryFinderResolver;
import org.apache.camel.quarkus.it.support.typeconverter.MyPair;
import org.apache.camel.quarkus.main.CamelMain;
import org.apache.camel.quarkus.main.CamelMainRoutesCollector;
import org.apache.camel.reactive.vertx.VertXReactiveExecutor;
import org.apache.camel.reactive.vertx.VertXThreadPoolFactory;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.ThreadPoolFactory;
import org.apache.camel.support.DefaultRegistry;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.support.processor.DefaultExchangeFormatter;

@Path(value="/test")
@ApplicationScoped
public class CoreMainResource {
    @Inject
    CamelMain main;

    @Path(value="/property/{name}")
    @GET
    @Produces(value={"text/plain"})
    public String getProperty(@PathParam(value="name") String name) throws Exception {
        return this.main.getCamelContext().resolvePropertyPlaceholders("{{" + name + "}}");
    }

    @Path(value="/timer/property-binding")
    @GET
    @Produces(value={"text/plain"})
    public boolean timerResolvePropertyPlaceholders() throws Exception {
        return ((TimerComponent)this.main.getCamelContext().getComponent("timer", TimerComponent.class)).isBasicPropertyBinding();
    }

    @Path(value="/registry/log/exchange-formatter")
    @GET
    @Produces(value={"application/json"})
    public JsonObject exchangeFormatterConfig() {
        LogComponent component = (LogComponent)this.main.getCamelContext().getRegistry().lookupByNameAndType("log", LogComponent.class);
        DefaultExchangeFormatter def = (DefaultExchangeFormatter)component.getExchangeFormatter();
        JsonObject result = Json.createObjectBuilder().add("show-all", def.isShowAll()).add("multi-line", def.isMultiline()).build();
        return result;
    }

    @Path(value="/context/name")
    @GET
    @Produces(value={"text/plain"})
    public String getCamelContextName() {
        return this.main.getCamelContext().getName();
    }

    @Path(value="/context/name")
    @POST
    @Produces(value={"text/plain"})
    public String setCamelContextName(String name) {
        ((ExtendedCamelContext)this.main.getCamelContext().adapt(ExtendedCamelContext.class)).setName(name);
        return this.main.getCamelContext().getName();
    }

    @Path(value="/main/describe")
    @GET
    @Produces(value={"application/json"})
    public JsonObject describeMain() {
        ExtendedCamelContext camelContext = (ExtendedCamelContext)this.main.getCamelContext().adapt(ExtendedCamelContext.class);
        JsonArrayBuilder listeners = Json.createArrayBuilder();
        this.main.getMainListeners().forEach(listener -> listeners.add(listener.getClass().getName()));
        JsonArrayBuilder routeBuilders = Json.createArrayBuilder();
        this.main.configure().getRoutesBuilders().forEach(builder -> routeBuilders.add(builder.getClass().getName()));
        JsonArrayBuilder routes = Json.createArrayBuilder();
        camelContext.getRoutes().forEach(route -> routes.add(route.getId()));
        JsonObjectBuilder collector = Json.createObjectBuilder();
        collector.add("type", this.main.getRoutesCollector().getClass().getName());
        if (this.main.getRoutesCollector() instanceof CamelMainRoutesCollector) {
            CamelMainRoutesCollector crc = (CamelMainRoutesCollector)this.main.getRoutesCollector();
            collector.add("type-registry", crc.getRegistryRoutesLoader().getClass().getName());
            collector.add("type-xml", crc.getXmlRoutesLoader().getClass().getName());
        }
        JsonObjectBuilder dataformatsInRegistry = Json.createObjectBuilder();
        camelContext.getRegistry().findByTypeWithName(DataFormat.class).forEach((name, value) -> dataformatsInRegistry.add(name, value.getClass().getName()));
        JsonObjectBuilder languagesInRegistry = Json.createObjectBuilder();
        camelContext.getRegistry().findByTypeWithName(Language.class).forEach((name, value) -> languagesInRegistry.add(name, value.getClass().getName()));
        JsonObjectBuilder componentsInRegistry = Json.createObjectBuilder();
        camelContext.getRegistry().findByTypeWithName(Component.class).forEach((name, value) -> componentsInRegistry.add(name, value.getClass().getName()));
        JsonObjectBuilder factoryClassMap = Json.createObjectBuilder();
        FactoryFinderResolver factoryFinderResolver = camelContext.getFactoryFinderResolver();
        if (factoryFinderResolver instanceof FastFactoryFinderResolver) {
            ((FastFactoryFinderResolver)factoryFinderResolver).getClassMap().forEach((k, v) -> factoryClassMap.add(k, v.getName()));
        }
        return Json.createObjectBuilder().add("xml-loader", camelContext.getXMLRoutesDefinitionLoader().getClass().getName()).add("xml-model-dumper", camelContext.getModelToXMLDumper().getClass().getName()).add("routes-collector", collector).add("listeners", listeners).add("routeBuilders", routeBuilders).add("routes", routes).add("lru-cache-factory", LRUCacheFactory.getInstance().getClass().getName()).add("autoConfigurationLogSummary", this.main.getMainConfigurationProperties().isAutoConfigurationLogSummary()).add("config", Json.createObjectBuilder().add("rest-port", camelContext.getRestConfiguration().getPort()).add("resilience4j-sliding-window-size", ((ModelCamelContext)camelContext.adapt(ModelCamelContext.class)).getResilience4jConfiguration(null).getSlidingWindowSize())).add("registry", Json.createObjectBuilder().add("components", componentsInRegistry).add("dataformats", dataformatsInRegistry).add("languages", languagesInRegistry)).add("factory-finder", Json.createObjectBuilder().add("class-map", factoryClassMap)).add("bean-introspection-invocations", camelContext.getBeanIntrospection().getInvokedCounter()).build();
    }

    @Path(value="/context/reactive-executor")
    @GET
    @Produces(value={"text/plain"})
    public JsonObject reactiveExecutor() {
        ReactiveExecutor executor = ((ExtendedCamelContext)this.main.getCamelContext().adapt(ExtendedCamelContext.class)).getReactiveExecutor();
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("class", executor.getClass().getName());
        if (executor instanceof VertXReactiveExecutor) {
            builder.add("configured", ((VertXReactiveExecutor)executor).getVertx() != null);
        }
        return builder.build();
    }

    @Path(value="/context/thread-pool-factory")
    @GET
    @Produces(value={"text/plain"})
    public JsonObject threadPoolFactory() {
        ThreadPoolFactory threadPoolFactory = ((ExtendedCamelContext)this.main.getCamelContext().adapt(ExtendedCamelContext.class)).getExecutorServiceManager().getThreadPoolFactory();
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("class", threadPoolFactory.getClass().getName());
        if (threadPoolFactory instanceof VertXThreadPoolFactory) {
            builder.add("configured", ((VertXThreadPoolFactory)threadPoolFactory).getVertx() != null);
        }
        return builder.build();
    }

    @Path(value="/converter/my-pair")
    @POST
    @Produces(value={"application/json"})
    public JsonObject fromStringToMyPair(String input) {
        MyPair pair = (MyPair)this.main.getCamelContext().getTypeConverter().convertTo(MyPair.class, (Object)input);
        return Json.createObjectBuilder().add("key", pair.key).add("val", pair.val).build();
    }

    @Path(value="/registry/component/{name}")
    @GET
    @Produces(value={"application/json"})
    public JsonObject describeRegistryComponent(@PathParam(value="name") String name) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        DefaultRegistry registry = (DefaultRegistry)this.main.getCamelContext().getRegistry(DefaultRegistry.class);
        JsonObjectBuilder builder = Json.createObjectBuilder();
        Component component = (Component)registry.getFallbackRegistry().lookupByNameAndType(name, Component.class);
        if (component != null) {
            builder.add("type", component.getClass().getName());
            builder.add("registry", "fallback");
            builder.add("registry-type", registry.getFallbackRegistry().getClass().getName());
        } else {
            for (BeanRepository repository : registry.getRepositories()) {
                component = (Component)repository.lookupByNameAndType(name, Component.class);
                if (component == null) continue;
                builder.add("type", component.getClass().getName());
                builder.add("registry", "repository");
                builder.add("registry-type", repository.getClass().getName());
                break;
            }
        }
        if (component != null) {
            ((ExtendedCamelContext)this.main.getCamelContext().adapt(ExtendedCamelContext.class)).getBeanIntrospection().getProperties((Object)component, properties, null);
            properties.forEach((k, v) -> {
                if (v != null) {
                    builder.add(k, Objects.toString(v));
                }
            });
        }
        return builder.build();
    }

    @Path(value="/registry/string/{name}")
    @GET
    @Produces(value={"text/plain"})
    public String getStringValueFromRegistry(@PathParam(value="name") String name) {
        DefaultRegistry registry = (DefaultRegistry)this.main.getCamelContext().getRegistry(DefaultRegistry.class);
        return (String)registry.getFallbackRegistry().lookupByNameAndType(name, String.class);
    }
}

