/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.main;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.camel.dsl.xml.io.XmlRoutesBuilderLoader;
import org.apache.camel.quarkus.core.DisabledXMLRoutesDefinitionLoader;
import org.apache.camel.xml.jaxb.DefaultModelJAXBContextFactory;
import org.apache.camel.xml.jaxb.JaxbModelToXMLDumper;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class CoreMainXmlJaxbTest {
    @Test
    public void testMainInstanceWithXmlRoutes() {
        JsonPath p = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept("application/json").get("/test/main/describe", new Object[0])).then()).statusCode(200)).extract().body().jsonPath();
        Assertions.assertThat((String)p.getString("xml-model-dumper")).isEqualTo(JaxbModelToXMLDumper.class.getName());
        Assertions.assertThat((String)p.getString("xml-model-factory")).isEqualTo(DefaultModelJAXBContextFactory.class.getName());
        Assertions.assertThat((String)p.getString("xml-routes-definitions-loader")).isEqualTo(DisabledXMLRoutesDefinitionLoader.class.getName());
        Assertions.assertThat((String)p.getString("xml-routes-builder-loader")).isEqualTo(XmlRoutesBuilderLoader.class.getName());
        Assertions.assertThat((List)p.getList("routeBuilders", String.class)).isEmpty();
        List routes = p.getList("routes", String.class);
        Assertions.assertThat((List)routes).contains((Object[])new String[]{"my-xml-route"});
        Assertions.assertThat((List)routes).contains((Object[])new String[]{"templated-route"});
        Assertions.assertThat((List)routes).contains((Object[])new String[]{"rest-route"});
    }

    @Test
    public void testDumpRoutes() {
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).pollDelay(100L, TimeUnit.MILLISECONDS).until(() -> {
            String log = new String(Files.readAllBytes(Paths.get("target/quarkus.log", new String[0])), StandardCharsets.UTF_8);
            return this.logContainsDumpedRoutes(log);
        });
    }

    private boolean logContainsDumpedRoutes(String log) {
        return log.contains("<route customId=\"true\" id=\"my-xml-route\">") && log.contains("<route customId=\"true\" id=\"rest-route\">") && log.contains("<rest customId=\"true\" id=\"greet\" path=\"/greeting\">") && log.contains("<routeTemplate customId=\"true\" id=\"myTemplate\">");
    }
}

