/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.main;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import org.apache.camel.dsl.xml.io.XmlRoutesBuilderLoader;
import org.apache.camel.quarkus.core.DisabledModelJAXBContextFactory;
import org.apache.camel.quarkus.core.DisabledModelToXMLDumper;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class CoreMainXmlIoTest {
    @Test
    public void testMainInstanceWithXmlRoutes() {
        JsonPath p = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept("application/json").get("/xml-io/describe", new Object[0])).then()).statusCode(200)).extract().body().jsonPath();
        Assertions.assertThat((String)p.getString("xml-model-dumper")).isEqualTo(DisabledModelToXMLDumper.class.getName());
        Assertions.assertThat((String)p.getString("xml-model-factory")).isEqualTo(DisabledModelJAXBContextFactory.class.getName());
        Assertions.assertThat((String)p.getString("xml-routes-builder-loader")).isEqualTo(XmlRoutesBuilderLoader.class.getName());
        Assertions.assertThat((List)p.getList("routeBuilders", String.class)).contains((Object[])new String[]{"org.apache.camel.quarkus.main.XmlIoRoutes"});
        List routes = p.getList("routes", String.class);
        Assertions.assertThat((List)routes).contains((Object[])new String[]{"my-xml-route"});
        Assertions.assertThat((List)routes).contains((Object[])new String[]{"templated-route"});
        Assertions.assertThat((List)routes).contains((Object[])new String[]{"rest-route"});
    }

    @Test
    public void namespaceAware() {
        String message = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<foo:foo-text xmlns:foo=\"http://camel.apache.org/foo\">bar</foo:foo-text>";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(message).post("/xml-io/route/namespace-aware", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"bar"), new Matcher[0]);
    }

    @Test
    public void validate() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("Kermit").post("/xml-io/route/validate", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello Kermit you were validated"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("Cookie Monster").post("/xml-io/route/validate", new Object[0])).then()).statusCode(500);
    }

    @Test
    public void routeEncodedInIso8859_15_ShouldSucceed() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("in").post("/xml-io/route/iso_8859_15-encoded", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"Hello World from ISO-8859-15 encoded route containing \u20ac symbol !"), new Matcher[0]);
    }

    @Test
    public void beanTypeShouldSucceed() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("beanTypeShouldSucceed").post("/xml-io/route/withBeanType", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"beanTypeShouldSucceed-handled-by-MyBean"), new Matcher[0]);
    }
}

