/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.main;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.quarkus.main.CamelMain;
import org.apache.camel.support.PluginHelper;

@Path(value="/xml-io")
@ApplicationScoped
public class CoreMainXmlIoResource {
    @Inject
    CamelMain main;
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/describe")
    @GET
    @Produces(value={"application/json"})
    public JsonObject describeMain() {
        ExtendedCamelContext camelContext = this.main.getCamelContext().getCamelContextExtension();
        JsonArrayBuilder listeners = Json.createArrayBuilder();
        this.main.getMainListeners().forEach(listener -> listeners.add(listener.getClass().getName()));
        JsonArrayBuilder routeBuilders = Json.createArrayBuilder();
        this.main.configure().getRoutesBuilders().forEach(builder -> routeBuilders.add(builder.getClass().getName()));
        JsonArrayBuilder routes = Json.createArrayBuilder();
        this.main.getCamelContext().getRoutes().forEach(route -> routes.add(route.getId()));
        return Json.createObjectBuilder().add("xml-routes-definitions-loader", PluginHelper.getRoutesLoader((ExtendedCamelContext)camelContext).getClass().getName()).add("xml-routes-builder-loader", ((Class)camelContext.getBootstrapFactoryFinder("META-INF/services/org/apache/camel/routes-loader/").findClass("xml").get()).getName()).add("xml-model-dumper", PluginHelper.getModelToXMLDumper((ExtendedCamelContext)camelContext).getClass().getName()).add("xml-model-factory", PluginHelper.getModelJAXBContextFactory((ExtendedCamelContext)camelContext).getClass().getName()).add("routeBuilders", routeBuilders).add("routes", routes).build();
    }

    @Path(value="/route/{route}")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String route(String statement, @PathParam(value="route") String route, @Context UriInfo uriInfo) {
        Map<String, Object> headers = uriInfo.getQueryParameters().entrySet().stream().map(e -> new AbstractMap.SimpleImmutableEntry((String)e.getKey(), ((List)e.getValue()).get(0))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return (String)this.producerTemplate.requestBodyAndHeaders("direct:" + route, (Object)statement, headers, String.class);
    }
}

