/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.main;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.TemplatedRouteBuilder;
import org.apache.camel.quarkus.main.CamelMain;

@Path(value="/xml-io")
@ApplicationScoped
public class CoreMainXmlIoResource {
    @Inject
    CamelMain main;
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/describe")
    @GET
    @Produces(value={"application/json"})
    public JsonObject describeMain() {
        ExtendedCamelContext camelContext = (ExtendedCamelContext)this.main.getCamelContext().adapt(ExtendedCamelContext.class);
        JsonArrayBuilder listeners = Json.createArrayBuilder();
        this.main.getMainListeners().forEach(listener -> listeners.add(listener.getClass().getName()));
        JsonArrayBuilder routeBuilders = Json.createArrayBuilder();
        this.main.configure().getRoutesBuilders().forEach(builder -> routeBuilders.add(builder.getClass().getName()));
        TemplatedRouteBuilder.builder((CamelContext)this.main.getCamelContext(), (String)"myTemplate").parameter("name", (Object)"Camel Quarkus").parameter("greeting", (Object)"Hello").routeId("templated-route").add();
        JsonArrayBuilder routes = Json.createArrayBuilder();
        this.main.getCamelContext().getRoutes().forEach(route -> routes.add(route.getId()));
        return Json.createObjectBuilder().add("xml-routes-definitions-loader", camelContext.getXMLRoutesDefinitionLoader().getClass().getName()).add("xml-routes-builder-loader", ((Class)camelContext.getBootstrapFactoryFinder("META-INF/services/org/apache/camel/routes-loader/").findClass("xml").get()).getName()).add("xml-model-dumper", camelContext.getModelToXMLDumper().getClass().getName()).add("xml-model-factory", camelContext.getModelJAXBContextFactory().getClass().getName()).add("routeBuilders", routeBuilders).add("routes", routes).build();
    }

    @Path(value="/route/{route}")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String route(String statement, @PathParam(value="route") String route, @Context UriInfo uriInfo) {
        Map<String, Object> headers = uriInfo.getQueryParameters().entrySet().stream().map(e -> new AbstractMap.SimpleImmutableEntry((String)e.getKey(), ((List)e.getValue()).get(0))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return (String)this.producerTemplate.requestBodyAndHeaders("direct:" + route, (Object)statement, headers, String.class);
    }
}

