/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.main;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import org.apache.camel.quarkus.core.DisabledModelJAXBContextFactory;
import org.apache.camel.quarkus.core.DisabledModelToXMLDumper;
import org.apache.camel.xml.in.ModelParserXMLRoutesDefinitionLoader;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class CoreMainXmlIoTest {
    @Test
    public void testMainInstanceWithXmlRoutes() {
        JsonPath p = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept("application/json").get("/test/main/describe", new Object[0])).then()).statusCode(200)).extract().body().jsonPath();
        Assertions.assertThat((String)p.getString("xml-loader")).isEqualTo(ModelParserXMLRoutesDefinitionLoader.class.getName());
        Assertions.assertThat((String)p.getString("xml-model-dumper")).isEqualTo(DisabledModelToXMLDumper.class.getName());
        Assertions.assertThat((String)p.getString("xml-model-factory")).isEqualTo(DisabledModelJAXBContextFactory.class.getName());
        Assertions.assertThat((List)p.getList("routeBuilders", String.class)).isEmpty();
        List routes = p.getList("routes", String.class);
        Assertions.assertThat((List)routes).contains((Object[])new String[]{"my-xml-route"});
        Assertions.assertThat((List)routes).contains((Object[])new String[]{"templated-route"});
        Assertions.assertThat((List)routes).contains((Object[])new String[]{"rest-route"});
    }

    @Test
    public void namespaceAware() {
        String message = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<foo:foo-text xmlns:foo=\"http://camel.apache.org/foo\">bar</foo:foo-text>";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.XML).body(message).post("/test/xml-io/namespace-aware", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"bar"), new Matcher[0]);
    }

    @Test
    public void csimpleXml() {
        ((ValidatableResponse)((Response)RestAssured.given().body("Joe").contentType(ContentType.TEXT).post("/test/csimple-xml-dsl", new Object[0])).then()).body(Matchers.is((Object)"Hi Joe"), new Matcher[0]);
    }
}

