/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.mail;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.attachment.AttachmentMessage;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mail.MailConverters;
import org.apache.camel.component.mail.MailMessage;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.jsse.KeyManagersParameters;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.jsse.TrustManagersParameters;
import org.eclipse.angus.mail.util.MailConnectException;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class CamelRoute
extends RouteBuilder {
    @Inject
    @Named(value="mailReceivedMessages")
    List<Map<String, Object>> mailReceivedMessages;
    @Inject
    CamelContext camelContext;
    static final String EMAIL_ADDRESS = "test@localhost";
    static final String USERNAME = "test";
    static final String PASSWORD = "s3cr3t";
    @ConfigProperty(name="mail.smtp.port")
    int smtpPort;
    @ConfigProperty(name="mail.smtps.port")
    int smtpsPort;
    @ConfigProperty(name="mail.pop3.port")
    int pop3Port;
    @ConfigProperty(name="mail.pop3s.port")
    int pop3sPort;
    @ConfigProperty(name="mail.imap.port")
    int imapPort;
    @ConfigProperty(name="mail.imaps.port")
    int imapsPort;

    public void configure() {
        ((OnExceptionDefinition)this.onException(MailConnectException.class).log("Failed to connect to mail host")).handled(false);
        this.from("direct:sendMail").toF("smtp://localhost:%d?username=%s&password=%s", new Object[]{this.smtpPort, USERNAME, PASSWORD});
        this.from("direct:sendMailSecured").toF("smtps://localhost:%d?username=%s&password=%s&sslContextParameters=#sslContextParameters&additionalJavaMailProperties=#additionalProperties", new Object[]{this.smtpsPort, USERNAME, PASSWORD});
        this.from("direct:mimeMultipartMarshal").marshal().mimeMultipart();
        this.from("direct:mimeMultipartUnmarshalMarshal").unmarshal().mimeMultipart().marshal().mimeMultipart();
        ((RouteDefinition)this.fromF("pop3://localhost:%d?initialDelay=100&delay=500&username=%s&password=%s&delete=true", new Object[]{this.pop3Port, USERNAME, PASSWORD}).id(Routes.pop3ReceiveRoute.name())).autoStartup(false).process(exchange -> this.handleMail(exchange));
        ((RouteDefinition)this.fromF("pop3s://localhost:%d?initialDelay=100&delay=500&username=%s&password=%s&delete=true&sslContextParameters=#sslContextParameters&additionalJavaMailProperties=#additionalProperties", new Object[]{this.pop3sPort, USERNAME, PASSWORD}).id(Routes.pop3sReceiveRoute.name())).autoStartup(false).process(exchange -> this.handleMail(exchange));
        ((RouteDefinition)this.fromF("imap://localhost:%d?initialDelay=100&delay=500&username=%s&password=%s&delete=true", new Object[]{this.imapPort, USERNAME, PASSWORD}).id(Routes.imapReceiveRoute.name())).autoStartup(false).process(exchange -> this.handleMail(exchange));
        ((RouteDefinition)this.fromF("imaps://localhost:%d?initialDelay=100&delay=500&username=%s&password=%s&delete=true&sslContextParameters=#sslContextParameters&additionalJavaMailProperties=#additionalProperties", new Object[]{this.imapsPort, USERNAME, PASSWORD}).id(Routes.imapsReceiveRoute.name())).autoStartup(false).process(exchange -> this.handleMail(exchange));
        ((RouteDefinition)this.fromF("pop3://localhost:%d?initialDelay=100&delay=500&username=%s&password=%s&delete=true&maxMessagesPerPoll=3", new Object[]{this.pop3Port, USERNAME, PASSWORD}).id(Routes.batchReceiveRoute.name())).autoStartup(false).process(e -> {
            Map<String, Object> map = this.handleMail(e);
            map.put(ExchangePropertyKey.BATCH_INDEX.getName(), e.getProperty(ExchangePropertyKey.BATCH_INDEX));
            map.put(ExchangePropertyKey.BATCH_COMPLETE.getName(), e.getProperty(ExchangePropertyKey.BATCH_COMPLETE));
            map.put(ExchangePropertyKey.BATCH_SIZE.getName(), e.getProperty(ExchangePropertyKey.BATCH_SIZE));
        });
        ((RouteDefinition)this.fromF("pop3://localhost:%d?initialDelay=100&delay=500&username=%s&password=%s&delete=true", new Object[]{this.pop3Port, USERNAME, PASSWORD}).id(Routes.convertersRoute.name())).autoStartup(false).process(e -> {
            MailConverters.toInputStream((Message)((MailMessage)e.getIn().getBody(MailMessage.class)).getMessage());
            InputStream is = MailConverters.toInputStream((Message)((MailMessage)e.getIn().getBody(MailMessage.class)).getMessage());
            Map<String, Object> map = this.handleMail(e);
            map.put("convertedStream", is);
        });
        this.from("direct:throwMailConnectException").to("smtp://bad.host.org?to=foo@bar.com");
    }

    private Map<String, Object> handleMail(Exchange exchange) throws MessagingException {
        Folder folder;
        HashMap<String, Object> result = new HashMap<String, Object>();
        MailMessage mailMessage = (MailMessage)exchange.getMessage(MailMessage.class);
        AttachmentMessage attachmentMessage = (AttachmentMessage)exchange.getMessage(AttachmentMessage.class);
        Map attachments = attachmentMessage.getAttachments();
        if (attachments != null) {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            attachments.forEach((id, dataHandler) -> {
                JsonObjectBuilder attachmentObject = Json.createObjectBuilder();
                attachmentObject.add("attachmentFilename", dataHandler.getName());
                attachmentObject.add("attachmentContentType", dataHandler.getContentType());
                if (dataHandler.getName().endsWith(".txt")) {
                    try {
                        String content = (String)this.camelContext.getTypeConverter().convertTo(String.class, (Object)dataHandler.getInputStream());
                        attachmentObject.add("attachmentContent", content);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }
                arrayBuilder.add((JsonValue)attachmentObject.build());
            });
            result.put("attachments", arrayBuilder.build());
        }
        if (!(folder = mailMessage.getOriginalMessage().getFolder()).isOpen()) {
            folder.open(1);
        }
        result.put("subject", mailMessage.getMessage().getSubject());
        result.put("content", ((String)mailMessage.getBody(String.class)).trim());
        this.mailReceivedMessages.add(result);
        return result;
    }

    static enum Routes {
        convertersRoute,
        batchReceiveRoute,
        imapReceiveRoute,
        imapsReceiveRoute,
        pop3ReceiveRoute,
        pop3sReceiveRoute;

    }

    static class Producers {
        Producers() {
        }

        @Singleton
        @Produces
        @Named(value="mailReceivedMessages")
        List<Map<String, Object>> mailReceivedMessages() {
            return new CopyOnWriteArrayList<Map<String, Object>>();
        }

        @Singleton
        @Named
        public SSLContextParameters sslContextParameters() {
            TrustManagersParameters trustManagersParameters = new TrustManagersParameters();
            SSLContextParameters sslContextParameters = new SSLContextParameters();
            sslContextParameters.setTrustManagers(trustManagersParameters);
            KeyManagersParameters keyManagersParameters = new KeyManagersParameters();
            sslContextParameters.setKeyManagers(keyManagersParameters);
            return sslContextParameters;
        }

        @Singleton
        @Named
        public Properties additionalProperties() {
            Properties prop = new Properties();
            prop.setProperty("mail.smtps.ssl.trust", "*");
            prop.setProperty("mail.pop3s.ssl.trust", "*");
            prop.setProperty("mail.imaps.ssl.trust", "*");
            return prop;
        }
    }
}

