/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.mail;

import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.util.ByteArrayDataSource;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.Message;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ServiceStatus;
import org.apache.camel.attachment.Attachment;
import org.apache.camel.attachment.AttachmentMessage;
import org.apache.camel.attachment.DefaultAttachment;
import org.apache.camel.component.mail.DefaultJavaMailSender;
import org.apache.camel.component.mail.MailSorter;
import org.apache.camel.quarkus.component.mail.CamelRoute;
import org.eclipse.angus.mail.imap.SortTerm;

@Path(value="/mail")
@ApplicationScoped
public class CamelResource {
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    CamelContext camelContext;
    @Inject
    @Named(value="mailReceivedMessages")
    List<Map<String, Object>> mailReceivedMessages;

    @Path(value="/send")
    @POST
    @Consumes(value={"text/plain"})
    public void sendMail(@QueryParam(value="subject") String subject, @QueryParam(value="from") String from, @QueryParam(value="to") String to, @QueryParam(value="secured") Boolean secured, String body) {
        String path = secured != null && secured != false ? "sendMailSecured" : "sendMail";
        this.producerTemplate.send("direct:" + path, exchange -> {
            Message message = exchange.getMessage();
            message.setHeader("Subject", (Object)subject);
            message.setHeader("From", (Object)from);
            message.setHeader("To", (Object)to);
            message.setBody((Object)body);
        });
    }

    @Path(value="/send/attachment/{fileName}")
    @POST
    @Consumes(value={"text/plain"})
    public void sendMailWithAttachment(@PathParam(value="fileName") String fileName, @QueryParam(value="subject") String subject, @QueryParam(value="from") String from, @QueryParam(value="to") String to, String body) {
        this.producerTemplate.send("direct:sendMail", exchange -> {
            AttachmentMessage in = (AttachmentMessage)exchange.getMessage(AttachmentMessage.class);
            DefaultAttachment attachment = fileName.startsWith("/") ? new DefaultAttachment((DataSource)new FileDataSource(fileName)) : new DefaultAttachment((DataSource)new ByteArrayDataSource(Thread.currentThread().getContextClassLoader().getResourceAsStream("data/" + fileName), "image/jpeg"));
            in.addAttachmentObject(fileName, (Attachment)attachment);
            Message message = exchange.getMessage();
            message.setHeader("Subject", (Object)subject);
            message.setHeader("From", (Object)from);
            message.setHeader("To", (Object)to);
            message.setBody((Object)body);
        });
    }

    @Path(value="/mimeMultipartUnmarshalMarshal")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String mimeMultipartUnmarshalMarshal(String body) {
        return (String)this.producerTemplate.requestBody("direct:mimeMultipartUnmarshalMarshal", (Object)body, String.class);
    }

    @Path(value="/mimeMultipartMarshal/{fileName}/{fileContent}")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String mimeMultipart(@PathParam(value="fileName") String fileName, @PathParam(value="fileContent") String fileContent, String body) {
        return (String)this.producerTemplate.request("direct:mimeMultipartMarshal", e -> {
            AttachmentMessage in = (AttachmentMessage)e.getMessage(AttachmentMessage.class);
            in.setBody((Object)body);
            in.setHeader("Content-Type", (Object)"text/plain;charset=iso8859-1;other-parameter=true");
            in.setHeader("Content-Encoding", (Object)"UTF8");
            DefaultAttachment attachment = new DefaultAttachment((DataSource)new ByteArrayDataSource(fileContent, "text/plain"));
            attachment.addHeader("Content-Description", "Sample Attachment Data");
            attachment.addHeader("X-AdditionalData", "additional data");
            in.addAttachmentObject(fileName, (Attachment)attachment);
        }).getMessage().getBody(String.class);
    }

    @Path(value="/getReceived")
    @GET
    @Produces(value={"application/json"})
    public List<Map<String, Object>> getReceived() {
        return this.mailReceivedMessages;
    }

    @Path(value="/getReceivedAsString")
    @GET
    @Produces(value={"application/json"})
    public List<Map<String, Object>> getReceivedAsString() throws MessagingException, IOException {
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        for (Map<String, Object> email : this.mailReceivedMessages) {
            InputStream is = (InputStream)email.get("convertedStream");
            result.add(Collections.singletonMap("body", this.camelContext.getTypeConverter().convertTo(String.class, (Object)is)));
        }
        this.mailReceivedMessages.clear();
        return result;
    }

    @Path(value="/clear")
    @GET
    public void clear() {
        this.mailReceivedMessages.clear();
    }

    @GET
    @Path(value="/route/{routeId}/{operation}")
    @Produces(value={"text/plain"})
    public String controlRoute(@PathParam(value="routeId") String routeId, @PathParam(value="operation") String operation) throws Exception {
        switch (operation) {
            case "stop": {
                this.camelContext.getRouteController().stopRoute(routeId);
                break;
            }
            case "start": {
                this.camelContext.getRouteController().startRoute(routeId);
                break;
            }
            case "status": {
                return this.camelContext.getRouteController().getRouteStatus(routeId).name();
            }
        }
        return null;
    }

    @GET
    @Path(value="/stopConsumers")
    @Produces(value={"text/plain"})
    public void stopConsumers() throws Exception {
        Arrays.stream(CamelRoute.Routes.values()).forEach(r -> {
            try {
                if (this.camelContext.getRouteController().getRouteStatus(r.name()) == ServiceStatus.Started) {
                    this.camelContext.getRouteController().stopRoute(r.name());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    @Path(value="/sort")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<String> sort(List<String> messages) throws Exception {
        DefaultJavaMailSender sender = new DefaultJavaMailSender();
        jakarta.mail.Message[] msgs = new jakarta.mail.Message[messages.size()];
        int i = 0;
        for (String msg : messages) {
            msgs[i] = new MimeMessage(sender.getSession());
            msgs[i].setHeader("Subject", msg);
            msgs[i++].setText(msg);
        }
        MailSorter.sortMessages((jakarta.mail.Message[])msgs, (SortTerm[])new SortTerm[]{SortTerm.SUBJECT});
        return Stream.of(msgs).map(m -> {
            try {
                return String.valueOf(m.getContent());
            }
            catch (Exception e) {
                return "error";
            }
        }).collect(Collectors.toList());
    }

    @Path(value="/exception")
    @GET
    public Response throwMailConnectException() {
        try {
            this.producerTemplate.requestBody("direct:throwMailConnectException", null);
            return Response.ok().build();
        }
        catch (Exception e) {
            Class<?> causeClass = e.getClass();
            if (e.getCause() != null) {
                causeClass = e.getCause().getClass();
            }
            return Response.serverError().entity((Object)causeClass.getName()).build();
        }
    }
}

