/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.mail;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.MountableFile;

public class MailTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOG = Logger.getLogger(MailTestResource.class);
    private static final String GREENMAIL_IMAGE_NAME = (String)ConfigProvider.getConfig().getValue("greenmail.container.image", String.class);
    private static final String GREENMAIL_CERTIFICATE_STORE_FILE = "greenmail.p12";
    private static final String GENERATE_CERTIFICATE_SCRIPT = "generate-certificates.sh";
    private GenericContainer<?> container;
    private Path certificateStoreLocation;

    public Map<String, String> start() {
        try {
            this.certificateStoreLocation = Files.createTempDirectory("MailTestResource-", new FileAttribute[0]);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try (InputStream in = classLoader.getResourceAsStream(GREENMAIL_CERTIFICATE_STORE_FILE);){
                Files.copy(in, this.certificateStoreLocation.resolve(GREENMAIL_CERTIFICATE_STORE_FILE), new CopyOption[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String dockerHost = DockerClientFactory.instance().dockerHostIpAddress();
        if (!dockerHost.equals("localhost") && !dockerHost.equals("127.0.0.1")) {
            this.regenerateCertificatesForDockerHost();
        }
        this.container = new GenericContainer(GREENMAIL_IMAGE_NAME).withCopyToContainer(Transferable.of((byte[])this.getCertificateStoreContent()), "/home/greenmail/greenmail.p12").withExposedPorts(MailProtocol.allPorts()).waitingFor((WaitStrategy)new HttpWaitStrategy().forPort(MailProtocol.API.getPort()).forPath("/api/service/readiness").forStatusCode(200));
        this.container.start();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("mail.host", this.container.getHost());
        for (MailProtocol protocol : MailProtocol.values()) {
            String optionName = String.format("mail.%s.port", protocol.name().toLowerCase());
            Integer mappedPort = this.container.getMappedPort(protocol.getPort());
            options.put(optionName, mappedPort.toString());
        }
        return options;
    }

    public void stop() {
        if (this.container != null) {
            this.container.stop();
        }
        if (this.certificateStoreLocation != null) {
            try {
                FileUtils.deleteDirectory((File)this.certificateStoreLocation.toFile());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void regenerateCertificatesForDockerHost() {
        String imageName = (String)ConfigProvider.getConfig().getValue("eclipse-temurin.container.image", String.class);
        try (GenericContainer container = new GenericContainer(imageName);){
            container.withCreateContainerCmdModifier(modifier -> {
                modifier.withEntrypoint(new String[]{"/bin/bash"});
                modifier.withStdinOpen(Boolean.valueOf(true));
                modifier.withAttachStdout(Boolean.valueOf(true));
            });
            container.setWorkingDirectory("/");
            container.start();
            String host = container.getHost();
            container.copyFileToContainer(MountableFile.forClasspathResource((String)GENERATE_CERTIFICATE_SCRIPT), "/generate-certificates.sh");
            Container.ExecResult result = container.execInContainer(new String[]{"/bin/bash", "/generate-certificates.sh", host, "DNS:%s,IP:%s".formatted(host, host), "/greenmail.p12"});
            LOG.info((Object)"generate-certificates.sh - STDOUT:");
            LOG.info((Object)result.getStdout());
            LOG.info((Object)"generate-certificates.sh - STDERR:");
            LOG.info((Object)result.getStderr());
            container.copyFileFromContainer("/greenmail.p12", this.certificateStoreLocation.resolve(GREENMAIL_CERTIFICATE_STORE_FILE).toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] getCertificateStoreContent() {
        try {
            return Files.readAllBytes(this.certificateStoreLocation.resolve(GREENMAIL_CERTIFICATE_STORE_FILE));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static enum MailProtocol {
        SMTP(3025),
        POP3(3110),
        IMAP(3143),
        SMTPS(3465),
        IMAPS(3993),
        POP3s(3995),
        API(8080);

        private final int port;

        private MailProtocol(int port) {
            this.port = port;
        }

        public int getPort() {
            return this.port;
        }

        public static Integer[] allPorts() {
            MailProtocol[] values = MailProtocol.values();
            Integer[] ports = new Integer[values.length];
            for (int i = 0; i < values.length; ++i) {
                ports[i] = values[i].getPort();
            }
            return ports;
        }
    }
}

